package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__long
import scala.jdk.CollectionConverters._
final case class BucketCountBySharedAccessType(
    external: Option[__long] = None,
    internal: Option[__long] = None,
    notShared: Option[__long] = None,
    unknown: Option[__long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BucketCountBySharedAccessType = {
    import BucketCountBySharedAccessType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BucketCountBySharedAccessType
      .builder()
      .optionallyWith(external.map(value => value: java.lang.Long))(_.external)
      .optionallyWith(internal.map(value => value: java.lang.Long))(_.internal)
      .optionallyWith(notShared.map(value => value: java.lang.Long))(
        _.notShared
      )
      .optionallyWith(unknown.map(value => value: java.lang.Long))(_.unknown)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.BucketCountBySharedAccessType.ReadOnly =
    zio.aws.macie2.model.BucketCountBySharedAccessType.wrap(buildAwsValue())
}
object BucketCountBySharedAccessType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BucketCountBySharedAccessType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.BucketCountBySharedAccessType =
      zio.aws.macie2.model.BucketCountBySharedAccessType(
        external.map(value => value),
        internal.map(value => value),
        notShared.map(value => value),
        unknown.map(value => value)
      )
    def external: Option[__long]
    def internal: Option[__long]
    def notShared: Option[__long]
    def unknown: Option[__long]
    def getExternal: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("external", external)
    def getInternal: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("internal", internal)
    def getNotShared: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("notShared", notShared)
    def getUnknown: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("unknown", unknown)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BucketCountBySharedAccessType
  ) extends zio.aws.macie2.model.BucketCountBySharedAccessType.ReadOnly {
    override val external: Option[__long] =
      scala.Option(impl.external()).map(value => value: __long)
    override val internal: Option[__long] =
      scala.Option(impl.internal()).map(value => value: __long)
    override val notShared: Option[__long] =
      scala.Option(impl.notShared()).map(value => value: __long)
    override val unknown: Option[__long] =
      scala.Option(impl.unknown()).map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BucketCountBySharedAccessType
  ): zio.aws.macie2.model.BucketCountBySharedAccessType.ReadOnly = new Wrapper(
    impl
  )
}
