package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UserIdentity(
    assumedRole: Option[zio.aws.macie2.model.AssumedRole] = None,
    awsAccount: Option[zio.aws.macie2.model.AwsAccount] = None,
    awsService: Option[zio.aws.macie2.model.AwsService] = None,
    federatedUser: Option[zio.aws.macie2.model.FederatedUser] = None,
    iamUser: Option[zio.aws.macie2.model.IamUser] = None,
    root: Option[zio.aws.macie2.model.UserIdentityRoot] = None,
    `type`: Option[zio.aws.macie2.model.UserIdentityType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UserIdentity = {
    import UserIdentity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UserIdentity
      .builder()
      .optionallyWith(assumedRole.map(value => value.buildAwsValue()))(
        _.assumedRole
      )
      .optionallyWith(awsAccount.map(value => value.buildAwsValue()))(
        _.awsAccount
      )
      .optionallyWith(awsService.map(value => value.buildAwsValue()))(
        _.awsService
      )
      .optionallyWith(federatedUser.map(value => value.buildAwsValue()))(
        _.federatedUser
      )
      .optionallyWith(iamUser.map(value => value.buildAwsValue()))(_.iamUser)
      .optionallyWith(root.map(value => value.buildAwsValue()))(_.root)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UserIdentity.ReadOnly =
    zio.aws.macie2.model.UserIdentity.wrap(buildAwsValue())
}
object UserIdentity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UserIdentity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UserIdentity =
      zio.aws.macie2.model.UserIdentity(
        assumedRole.map(value => value.asEditable),
        awsAccount.map(value => value.asEditable),
        awsService.map(value => value.asEditable),
        federatedUser.map(value => value.asEditable),
        iamUser.map(value => value.asEditable),
        root.map(value => value.asEditable),
        `type`.map(value => value)
      )
    def assumedRole: Option[zio.aws.macie2.model.AssumedRole.ReadOnly]
    def awsAccount: Option[zio.aws.macie2.model.AwsAccount.ReadOnly]
    def awsService: Option[zio.aws.macie2.model.AwsService.ReadOnly]
    def federatedUser: Option[zio.aws.macie2.model.FederatedUser.ReadOnly]
    def iamUser: Option[zio.aws.macie2.model.IamUser.ReadOnly]
    def root: Option[zio.aws.macie2.model.UserIdentityRoot.ReadOnly]
    def `type`: Option[zio.aws.macie2.model.UserIdentityType]
    def getAssumedRole
        : ZIO[Any, AwsError, zio.aws.macie2.model.AssumedRole.ReadOnly] =
      AwsError.unwrapOptionField("assumedRole", assumedRole)
    def getAwsAccount
        : ZIO[Any, AwsError, zio.aws.macie2.model.AwsAccount.ReadOnly] =
      AwsError.unwrapOptionField("awsAccount", awsAccount)
    def getAwsService
        : ZIO[Any, AwsError, zio.aws.macie2.model.AwsService.ReadOnly] =
      AwsError.unwrapOptionField("awsService", awsService)
    def getFederatedUser
        : ZIO[Any, AwsError, zio.aws.macie2.model.FederatedUser.ReadOnly] =
      AwsError.unwrapOptionField("federatedUser", federatedUser)
    def getIamUser: ZIO[Any, AwsError, zio.aws.macie2.model.IamUser.ReadOnly] =
      AwsError.unwrapOptionField("iamUser", iamUser)
    def getRoot
        : ZIO[Any, AwsError, zio.aws.macie2.model.UserIdentityRoot.ReadOnly] =
      AwsError.unwrapOptionField("root", root)
    def getType: ZIO[Any, AwsError, zio.aws.macie2.model.UserIdentityType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UserIdentity
  ) extends zio.aws.macie2.model.UserIdentity.ReadOnly {
    override val assumedRole
        : Option[zio.aws.macie2.model.AssumedRole.ReadOnly] = scala
      .Option(impl.assumedRole())
      .map(value => zio.aws.macie2.model.AssumedRole.wrap(value))
    override val awsAccount: Option[zio.aws.macie2.model.AwsAccount.ReadOnly] =
      scala
        .Option(impl.awsAccount())
        .map(value => zio.aws.macie2.model.AwsAccount.wrap(value))
    override val awsService: Option[zio.aws.macie2.model.AwsService.ReadOnly] =
      scala
        .Option(impl.awsService())
        .map(value => zio.aws.macie2.model.AwsService.wrap(value))
    override val federatedUser
        : Option[zio.aws.macie2.model.FederatedUser.ReadOnly] = scala
      .Option(impl.federatedUser())
      .map(value => zio.aws.macie2.model.FederatedUser.wrap(value))
    override val iamUser: Option[zio.aws.macie2.model.IamUser.ReadOnly] = scala
      .Option(impl.iamUser())
      .map(value => zio.aws.macie2.model.IamUser.wrap(value))
    override val root: Option[zio.aws.macie2.model.UserIdentityRoot.ReadOnly] =
      scala
        .Option(impl.root())
        .map(value => zio.aws.macie2.model.UserIdentityRoot.wrap(value))
    override val `type`: Option[zio.aws.macie2.model.UserIdentityType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.macie2.model.UserIdentityType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UserIdentity
  ): zio.aws.macie2.model.UserIdentity.ReadOnly = new Wrapper(impl)
}
