package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class UsageTotal(
    currency: Option[zio.aws.macie2.model.Currency] = None,
    estimatedCost: Option[__string] = None,
    `type`: Option[zio.aws.macie2.model.UsageType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UsageTotal = {
    import UsageTotal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UsageTotal
      .builder()
      .optionallyWith(currency.map(value => value.unwrap))(_.currency)
      .optionallyWith(estimatedCost.map(value => value: java.lang.String))(
        _.estimatedCost
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UsageTotal.ReadOnly =
    zio.aws.macie2.model.UsageTotal.wrap(buildAwsValue())
}
object UsageTotal {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.UsageTotal] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UsageTotal =
      zio.aws.macie2.model.UsageTotal(
        currency.map(value => value),
        estimatedCost.map(value => value),
        `type`.map(value => value)
      )
    def currency: Option[zio.aws.macie2.model.Currency]
    def estimatedCost: Option[__string]
    def `type`: Option[zio.aws.macie2.model.UsageType]
    def getCurrency: ZIO[Any, AwsError, zio.aws.macie2.model.Currency] =
      AwsError.unwrapOptionField("currency", currency)
    def getEstimatedCost: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("estimatedCost", estimatedCost)
    def getType: ZIO[Any, AwsError, zio.aws.macie2.model.UsageType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UsageTotal
  ) extends zio.aws.macie2.model.UsageTotal.ReadOnly {
    override val currency: Option[zio.aws.macie2.model.Currency] = scala
      .Option(impl.currency())
      .map(value => zio.aws.macie2.model.Currency.wrap(value))
    override val estimatedCost: Option[__string] =
      scala.Option(impl.estimatedCost()).map(value => value: __string)
    override val `type`: Option[zio.aws.macie2.model.UsageType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.macie2.model.UsageType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UsageTotal
  ): zio.aws.macie2.model.UsageTotal.ReadOnly = new Wrapper(impl)
}
