package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class UsageByAccount(
    currency: Option[zio.aws.macie2.model.Currency] = None,
    estimatedCost: Option[__string] = None,
    serviceLimit: Option[zio.aws.macie2.model.ServiceLimit] = None,
    `type`: Option[zio.aws.macie2.model.UsageType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UsageByAccount = {
    import UsageByAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UsageByAccount
      .builder()
      .optionallyWith(currency.map(value => value.unwrap))(_.currency)
      .optionallyWith(estimatedCost.map(value => value: java.lang.String))(
        _.estimatedCost
      )
      .optionallyWith(serviceLimit.map(value => value.buildAwsValue()))(
        _.serviceLimit
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UsageByAccount.ReadOnly =
    zio.aws.macie2.model.UsageByAccount.wrap(buildAwsValue())
}
object UsageByAccount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UsageByAccount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UsageByAccount =
      zio.aws.macie2.model.UsageByAccount(
        currency.map(value => value),
        estimatedCost.map(value => value),
        serviceLimit.map(value => value.asEditable),
        `type`.map(value => value)
      )
    def currency: Option[zio.aws.macie2.model.Currency]
    def estimatedCost: Option[__string]
    def serviceLimit: Option[zio.aws.macie2.model.ServiceLimit.ReadOnly]
    def `type`: Option[zio.aws.macie2.model.UsageType]
    def getCurrency: ZIO[Any, AwsError, zio.aws.macie2.model.Currency] =
      AwsError.unwrapOptionField("currency", currency)
    def getEstimatedCost: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("estimatedCost", estimatedCost)
    def getServiceLimit
        : ZIO[Any, AwsError, zio.aws.macie2.model.ServiceLimit.ReadOnly] =
      AwsError.unwrapOptionField("serviceLimit", serviceLimit)
    def getType: ZIO[Any, AwsError, zio.aws.macie2.model.UsageType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UsageByAccount
  ) extends zio.aws.macie2.model.UsageByAccount.ReadOnly {
    override val currency: Option[zio.aws.macie2.model.Currency] = scala
      .Option(impl.currency())
      .map(value => zio.aws.macie2.model.Currency.wrap(value))
    override val estimatedCost: Option[__string] =
      scala.Option(impl.estimatedCost()).map(value => value: __string)
    override val serviceLimit
        : Option[zio.aws.macie2.model.ServiceLimit.ReadOnly] = scala
      .Option(impl.serviceLimit())
      .map(value => zio.aws.macie2.model.ServiceLimit.wrap(value))
    override val `type`: Option[zio.aws.macie2.model.UsageType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.macie2.model.UsageType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UsageByAccount
  ): zio.aws.macie2.model.UsageByAccount.ReadOnly = new Wrapper(impl)
}
