package zio.aws.macie2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__string, __integer}
import scala.jdk.CollectionConverters._
final case class ListFindingsRequest(
    findingCriteria: Option[zio.aws.macie2.model.FindingCriteria] = None,
    maxResults: Option[__integer] = None,
    nextToken: Option[__string] = None,
    sortCriteria: Option[zio.aws.macie2.model.SortCriteria] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ListFindingsRequest = {
    import ListFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ListFindingsRequest
      .builder()
      .optionallyWith(findingCriteria.map(value => value.buildAwsValue()))(
        _.findingCriteria
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(sortCriteria.map(value => value.buildAwsValue()))(
        _.sortCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ListFindingsRequest.ReadOnly =
    zio.aws.macie2.model.ListFindingsRequest.wrap(buildAwsValue())
}
object ListFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ListFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ListFindingsRequest =
      zio.aws.macie2.model.ListFindingsRequest(
        findingCriteria.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortCriteria.map(value => value.asEditable)
      )
    def findingCriteria: Option[zio.aws.macie2.model.FindingCriteria.ReadOnly]
    def maxResults: Option[__integer]
    def nextToken: Option[__string]
    def sortCriteria: Option[zio.aws.macie2.model.SortCriteria.ReadOnly]
    def getFindingCriteria
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingCriteria.ReadOnly] =
      AwsError.unwrapOptionField("findingCriteria", findingCriteria)
    def getMaxResults: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortCriteria
        : ZIO[Any, AwsError, zio.aws.macie2.model.SortCriteria.ReadOnly] =
      AwsError.unwrapOptionField("sortCriteria", sortCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ListFindingsRequest
  ) extends zio.aws.macie2.model.ListFindingsRequest.ReadOnly {
    override val findingCriteria
        : Option[zio.aws.macie2.model.FindingCriteria.ReadOnly] = scala
      .Option(impl.findingCriteria())
      .map(value => zio.aws.macie2.model.FindingCriteria.wrap(value))
    override val maxResults: Option[__integer] =
      scala.Option(impl.maxResults()).map(value => value: __integer)
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val sortCriteria
        : Option[zio.aws.macie2.model.SortCriteria.ReadOnly] = scala
      .Option(impl.sortCriteria())
      .map(value => zio.aws.macie2.model.SortCriteria.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ListFindingsRequest
  ): zio.aws.macie2.model.ListFindingsRequest.ReadOnly = new Wrapper(impl)
}
