package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__string, __long}
import scala.jdk.CollectionConverters._
final case class GroupCount(
    count: Option[__long] = None,
    groupKey: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GroupCount = {
    import GroupCount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GroupCount
      .builder()
      .optionallyWith(count.map(value => value: java.lang.Long))(_.count)
      .optionallyWith(groupKey.map(value => value: java.lang.String))(
        _.groupKey
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GroupCount.ReadOnly =
    zio.aws.macie2.model.GroupCount.wrap(buildAwsValue())
}
object GroupCount {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.GroupCount] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GroupCount = zio.aws.macie2.model
      .GroupCount(count.map(value => value), groupKey.map(value => value))
    def count: Option[__long]
    def groupKey: Option[__string]
    def getCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("count", count)
    def getGroupKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("groupKey", groupKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GroupCount
  ) extends zio.aws.macie2.model.GroupCount.ReadOnly {
    override val count: Option[__long] =
      scala.Option(impl.count()).map(value => value: __long)
    override val groupKey: Option[__string] =
      scala.Option(impl.groupKey()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GroupCount
  ): zio.aws.macie2.model.GroupCount.ReadOnly = new Wrapper(impl)
}
