package zio.aws.macie2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__string, __integer}
import scala.jdk.CollectionConverters._
final case class GetUsageStatisticsRequest(
    filterBy: Option[Iterable[zio.aws.macie2.model.UsageStatisticsFilter]] =
      None,
    maxResults: Option[__integer] = None,
    nextToken: Option[__string] = None,
    sortBy: Option[zio.aws.macie2.model.UsageStatisticsSortBy] = None,
    timeRange: Option[zio.aws.macie2.model.TimeRange] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest = {
    import GetUsageStatisticsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest
      .builder()
      .optionallyWith(
        filterBy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filterBy)
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(sortBy.map(value => value.buildAwsValue()))(_.sortBy)
      .optionallyWith(timeRange.map(value => value.unwrap))(_.timeRange)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetUsageStatisticsRequest.ReadOnly =
    zio.aws.macie2.model.GetUsageStatisticsRequest.wrap(buildAwsValue())
}
object GetUsageStatisticsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetUsageStatisticsRequest =
      zio.aws.macie2.model.GetUsageStatisticsRequest(
        filterBy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sortBy.map(value => value.asEditable),
        timeRange.map(value => value)
      )
    def filterBy
        : Option[List[zio.aws.macie2.model.UsageStatisticsFilter.ReadOnly]]
    def maxResults: Option[__integer]
    def nextToken: Option[__string]
    def sortBy: Option[zio.aws.macie2.model.UsageStatisticsSortBy.ReadOnly]
    def timeRange: Option[zio.aws.macie2.model.TimeRange]
    def getFilterBy: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.UsageStatisticsFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filterBy", filterBy)
    def getMaxResults: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSortBy: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.UsageStatisticsSortBy.ReadOnly
    ] = AwsError.unwrapOptionField("sortBy", sortBy)
    def getTimeRange: ZIO[Any, AwsError, zio.aws.macie2.model.TimeRange] =
      AwsError.unwrapOptionField("timeRange", timeRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest
  ) extends zio.aws.macie2.model.GetUsageStatisticsRequest.ReadOnly {
    override val filterBy
        : Option[List[zio.aws.macie2.model.UsageStatisticsFilter.ReadOnly]] =
      scala
        .Option(impl.filterBy())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.UsageStatisticsFilter.wrap(item)
          }.toList
        )
    override val maxResults: Option[__integer] =
      scala.Option(impl.maxResults()).map(value => value: __integer)
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
    override val sortBy
        : Option[zio.aws.macie2.model.UsageStatisticsSortBy.ReadOnly] = scala
      .Option(impl.sortBy())
      .map(value => zio.aws.macie2.model.UsageStatisticsSortBy.wrap(value))
    override val timeRange: Option[zio.aws.macie2.model.TimeRange] = scala
      .Option(impl.timeRange())
      .map(value => zio.aws.macie2.model.TimeRange.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetUsageStatisticsRequest
  ): zio.aws.macie2.model.GetUsageStatisticsRequest.ReadOnly = new Wrapper(impl)
}
