package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__long, __string}
import scala.jdk.CollectionConverters._
final case class CustomDetection(
    arn: Option[__string] = None,
    count: Option[__long] = None,
    name: Option[__string] = None,
    occurrences: Option[zio.aws.macie2.model.Occurrences] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CustomDetection = {
    import CustomDetection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CustomDetection
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(count.map(value => value: java.lang.Long))(_.count)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(occurrences.map(value => value.buildAwsValue()))(
        _.occurrences
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.CustomDetection.ReadOnly =
    zio.aws.macie2.model.CustomDetection.wrap(buildAwsValue())
}
object CustomDetection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CustomDetection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CustomDetection =
      zio.aws.macie2.model.CustomDetection(
        arn.map(value => value),
        count.map(value => value),
        name.map(value => value),
        occurrences.map(value => value.asEditable)
      )
    def arn: Option[__string]
    def count: Option[__long]
    def name: Option[__string]
    def occurrences: Option[zio.aws.macie2.model.Occurrences.ReadOnly]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("count", count)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getOccurrences
        : ZIO[Any, AwsError, zio.aws.macie2.model.Occurrences.ReadOnly] =
      AwsError.unwrapOptionField("occurrences", occurrences)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CustomDetection
  ) extends zio.aws.macie2.model.CustomDetection.ReadOnly {
    override val arn: Option[__string] =
      scala.Option(impl.arn()).map(value => value: __string)
    override val count: Option[__long] =
      scala.Option(impl.count()).map(value => value: __long)
    override val name: Option[__string] =
      scala.Option(impl.name()).map(value => value: __string)
    override val occurrences
        : Option[zio.aws.macie2.model.Occurrences.ReadOnly] = scala
      .Option(impl.occurrences())
      .map(value => zio.aws.macie2.model.Occurrences.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CustomDetection
  ): zio.aws.macie2.model.CustomDetection.ReadOnly = new Wrapper(impl)
}
