package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{
  __boolean,
  __long,
  __timestampIso8601,
  __string
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class BucketMetadata(
    accountId: Option[__string] = None,
    allowsUnencryptedObjectUploads: Option[
      zio.aws.macie2.model.AllowsUnencryptedObjectUploads
    ] = None,
    bucketArn: Option[__string] = None,
    bucketCreatedAt: Option[__timestampIso8601] = None,
    bucketName: Option[__string] = None,
    classifiableObjectCount: Option[__long] = None,
    classifiableSizeInBytes: Option[__long] = None,
    errorCode: Option[zio.aws.macie2.model.BucketMetadataErrorCode] = None,
    errorMessage: Option[__string] = None,
    jobDetails: Option[zio.aws.macie2.model.JobDetails] = None,
    lastUpdated: Option[__timestampIso8601] = None,
    objectCount: Option[__long] = None,
    objectCountByEncryptionType: Option[
      zio.aws.macie2.model.ObjectCountByEncryptionType
    ] = None,
    publicAccess: Option[zio.aws.macie2.model.BucketPublicAccess] = None,
    region: Option[__string] = None,
    replicationDetails: Option[zio.aws.macie2.model.ReplicationDetails] = None,
    serverSideEncryption: Option[
      zio.aws.macie2.model.BucketServerSideEncryption
    ] = None,
    sharedAccess: Option[zio.aws.macie2.model.SharedAccess] = None,
    sizeInBytes: Option[__long] = None,
    sizeInBytesCompressed: Option[__long] = None,
    tags: Option[Iterable[zio.aws.macie2.model.KeyValuePair]] = None,
    unclassifiableObjectCount: Option[
      zio.aws.macie2.model.ObjectLevelStatistics
    ] = None,
    unclassifiableObjectSizeInBytes: Option[
      zio.aws.macie2.model.ObjectLevelStatistics
    ] = None,
    versioning: Option[__boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.BucketMetadata = {
    import BucketMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.BucketMetadata
      .builder()
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(
        allowsUnencryptedObjectUploads.map(value => value.unwrap)
      )(_.allowsUnencryptedObjectUploads)
      .optionallyWith(bucketArn.map(value => value: java.lang.String))(
        _.bucketArn
      )
      .optionallyWith(bucketCreatedAt.map(value => value: Instant))(
        _.bucketCreatedAt
      )
      .optionallyWith(bucketName.map(value => value: java.lang.String))(
        _.bucketName
      )
      .optionallyWith(
        classifiableObjectCount.map(value => value: java.lang.Long)
      )(_.classifiableObjectCount)
      .optionallyWith(
        classifiableSizeInBytes.map(value => value: java.lang.Long)
      )(_.classifiableSizeInBytes)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(jobDetails.map(value => value.buildAwsValue()))(
        _.jobDetails
      )
      .optionallyWith(lastUpdated.map(value => value: Instant))(_.lastUpdated)
      .optionallyWith(objectCount.map(value => value: java.lang.Long))(
        _.objectCount
      )
      .optionallyWith(
        objectCountByEncryptionType.map(value => value.buildAwsValue())
      )(_.objectCountByEncryptionType)
      .optionallyWith(publicAccess.map(value => value.buildAwsValue()))(
        _.publicAccess
      )
      .optionallyWith(region.map(value => value: java.lang.String))(_.region)
      .optionallyWith(replicationDetails.map(value => value.buildAwsValue()))(
        _.replicationDetails
      )
      .optionallyWith(serverSideEncryption.map(value => value.buildAwsValue()))(
        _.serverSideEncryption
      )
      .optionallyWith(sharedAccess.map(value => value.unwrap))(_.sharedAccess)
      .optionallyWith(sizeInBytes.map(value => value: java.lang.Long))(
        _.sizeInBytes
      )
      .optionallyWith(
        sizeInBytesCompressed.map(value => value: java.lang.Long)
      )(_.sizeInBytesCompressed)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        unclassifiableObjectCount.map(value => value.buildAwsValue())
      )(_.unclassifiableObjectCount)
      .optionallyWith(
        unclassifiableObjectSizeInBytes.map(value => value.buildAwsValue())
      )(_.unclassifiableObjectSizeInBytes)
      .optionallyWith(versioning.map(value => value: java.lang.Boolean))(
        _.versioning
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.BucketMetadata.ReadOnly =
    zio.aws.macie2.model.BucketMetadata.wrap(buildAwsValue())
}
object BucketMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.BucketMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.BucketMetadata =
      zio.aws.macie2.model.BucketMetadata(
        accountId.map(value => value),
        allowsUnencryptedObjectUploads.map(value => value),
        bucketArn.map(value => value),
        bucketCreatedAt.map(value => value),
        bucketName.map(value => value),
        classifiableObjectCount.map(value => value),
        classifiableSizeInBytes.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value),
        jobDetails.map(value => value.asEditable),
        lastUpdated.map(value => value),
        objectCount.map(value => value),
        objectCountByEncryptionType.map(value => value.asEditable),
        publicAccess.map(value => value.asEditable),
        region.map(value => value),
        replicationDetails.map(value => value.asEditable),
        serverSideEncryption.map(value => value.asEditable),
        sharedAccess.map(value => value),
        sizeInBytes.map(value => value),
        sizeInBytesCompressed.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        unclassifiableObjectCount.map(value => value.asEditable),
        unclassifiableObjectSizeInBytes.map(value => value.asEditable),
        versioning.map(value => value)
      )
    def accountId: Option[__string]
    def allowsUnencryptedObjectUploads
        : Option[zio.aws.macie2.model.AllowsUnencryptedObjectUploads]
    def bucketArn: Option[__string]
    def bucketCreatedAt: Option[__timestampIso8601]
    def bucketName: Option[__string]
    def classifiableObjectCount: Option[__long]
    def classifiableSizeInBytes: Option[__long]
    def errorCode: Option[zio.aws.macie2.model.BucketMetadataErrorCode]
    def errorMessage: Option[__string]
    def jobDetails: Option[zio.aws.macie2.model.JobDetails.ReadOnly]
    def lastUpdated: Option[__timestampIso8601]
    def objectCount: Option[__long]
    def objectCountByEncryptionType
        : Option[zio.aws.macie2.model.ObjectCountByEncryptionType.ReadOnly]
    def publicAccess: Option[zio.aws.macie2.model.BucketPublicAccess.ReadOnly]
    def region: Option[__string]
    def replicationDetails
        : Option[zio.aws.macie2.model.ReplicationDetails.ReadOnly]
    def serverSideEncryption
        : Option[zio.aws.macie2.model.BucketServerSideEncryption.ReadOnly]
    def sharedAccess: Option[zio.aws.macie2.model.SharedAccess]
    def sizeInBytes: Option[__long]
    def sizeInBytesCompressed: Option[__long]
    def tags: Option[List[zio.aws.macie2.model.KeyValuePair.ReadOnly]]
    def unclassifiableObjectCount
        : Option[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly]
    def unclassifiableObjectSizeInBytes
        : Option[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly]
    def versioning: Option[__boolean]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAllowsUnencryptedObjectUploads: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.AllowsUnencryptedObjectUploads
    ] = AwsError.unwrapOptionField(
      "allowsUnencryptedObjectUploads",
      allowsUnencryptedObjectUploads
    )
    def getBucketArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bucketArn", bucketArn)
    def getBucketCreatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("bucketCreatedAt", bucketCreatedAt)
    def getBucketName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getClassifiableObjectCount: ZIO[Any, AwsError, __long] = AwsError
      .unwrapOptionField("classifiableObjectCount", classifiableObjectCount)
    def getClassifiableSizeInBytes: ZIO[Any, AwsError, __long] = AwsError
      .unwrapOptionField("classifiableSizeInBytes", classifiableSizeInBytes)
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.macie2.model.BucketMetadataErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getJobDetails
        : ZIO[Any, AwsError, zio.aws.macie2.model.JobDetails.ReadOnly] =
      AwsError.unwrapOptionField("jobDetails", jobDetails)
    def getLastUpdated: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getObjectCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("objectCount", objectCount)
    def getObjectCountByEncryptionType: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ObjectCountByEncryptionType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "objectCountByEncryptionType",
      objectCountByEncryptionType
    )
    def getPublicAccess
        : ZIO[Any, AwsError, zio.aws.macie2.model.BucketPublicAccess.ReadOnly] =
      AwsError.unwrapOptionField("publicAccess", publicAccess)
    def getRegion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("region", region)
    def getReplicationDetails
        : ZIO[Any, AwsError, zio.aws.macie2.model.ReplicationDetails.ReadOnly] =
      AwsError.unwrapOptionField("replicationDetails", replicationDetails)
    def getServerSideEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.BucketServerSideEncryption.ReadOnly
    ] = AwsError.unwrapOptionField("serverSideEncryption", serverSideEncryption)
    def getSharedAccess: ZIO[Any, AwsError, zio.aws.macie2.model.SharedAccess] =
      AwsError.unwrapOptionField("sharedAccess", sharedAccess)
    def getSizeInBytes: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("sizeInBytes", sizeInBytes)
    def getSizeInBytesCompressed: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("sizeInBytesCompressed", sizeInBytesCompressed)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.KeyValuePair.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUnclassifiableObjectCount: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "unclassifiableObjectCount",
      unclassifiableObjectCount
    )
    def getUnclassifiableObjectSizeInBytes: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "unclassifiableObjectSizeInBytes",
      unclassifiableObjectSizeInBytes
    )
    def getVersioning: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("versioning", versioning)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.BucketMetadata
  ) extends zio.aws.macie2.model.BucketMetadata.ReadOnly {
    override val accountId: Option[__string] =
      scala.Option(impl.accountId()).map(value => value: __string)
    override val allowsUnencryptedObjectUploads
        : Option[zio.aws.macie2.model.AllowsUnencryptedObjectUploads] = scala
      .Option(impl.allowsUnencryptedObjectUploads())
      .map(value =>
        zio.aws.macie2.model.AllowsUnencryptedObjectUploads.wrap(value)
      )
    override val bucketArn: Option[__string] =
      scala.Option(impl.bucketArn()).map(value => value: __string)
    override val bucketCreatedAt: Option[__timestampIso8601] = scala
      .Option(impl.bucketCreatedAt())
      .map(value => value: __timestampIso8601)
    override val bucketName: Option[__string] =
      scala.Option(impl.bucketName()).map(value => value: __string)
    override val classifiableObjectCount: Option[__long] =
      scala.Option(impl.classifiableObjectCount()).map(value => value: __long)
    override val classifiableSizeInBytes: Option[__long] =
      scala.Option(impl.classifiableSizeInBytes()).map(value => value: __long)
    override val errorCode
        : Option[zio.aws.macie2.model.BucketMetadataErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.macie2.model.BucketMetadataErrorCode.wrap(value))
    override val errorMessage: Option[__string] =
      scala.Option(impl.errorMessage()).map(value => value: __string)
    override val jobDetails: Option[zio.aws.macie2.model.JobDetails.ReadOnly] =
      scala
        .Option(impl.jobDetails())
        .map(value => zio.aws.macie2.model.JobDetails.wrap(value))
    override val lastUpdated: Option[__timestampIso8601] =
      scala.Option(impl.lastUpdated()).map(value => value: __timestampIso8601)
    override val objectCount: Option[__long] =
      scala.Option(impl.objectCount()).map(value => value: __long)
    override val objectCountByEncryptionType
        : Option[zio.aws.macie2.model.ObjectCountByEncryptionType.ReadOnly] =
      scala
        .Option(impl.objectCountByEncryptionType())
        .map(value =>
          zio.aws.macie2.model.ObjectCountByEncryptionType.wrap(value)
        )
    override val publicAccess
        : Option[zio.aws.macie2.model.BucketPublicAccess.ReadOnly] = scala
      .Option(impl.publicAccess())
      .map(value => zio.aws.macie2.model.BucketPublicAccess.wrap(value))
    override val region: Option[__string] =
      scala.Option(impl.region()).map(value => value: __string)
    override val replicationDetails
        : Option[zio.aws.macie2.model.ReplicationDetails.ReadOnly] = scala
      .Option(impl.replicationDetails())
      .map(value => zio.aws.macie2.model.ReplicationDetails.wrap(value))
    override val serverSideEncryption
        : Option[zio.aws.macie2.model.BucketServerSideEncryption.ReadOnly] =
      scala
        .Option(impl.serverSideEncryption())
        .map(value =>
          zio.aws.macie2.model.BucketServerSideEncryption.wrap(value)
        )
    override val sharedAccess: Option[zio.aws.macie2.model.SharedAccess] = scala
      .Option(impl.sharedAccess())
      .map(value => zio.aws.macie2.model.SharedAccess.wrap(value))
    override val sizeInBytes: Option[__long] =
      scala.Option(impl.sizeInBytes()).map(value => value: __long)
    override val sizeInBytesCompressed: Option[__long] =
      scala.Option(impl.sizeInBytesCompressed()).map(value => value: __long)
    override val tags
        : Option[List[zio.aws.macie2.model.KeyValuePair.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.KeyValuePair.wrap(item)
        }.toList
      )
    override val unclassifiableObjectCount
        : Option[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly] = scala
      .Option(impl.unclassifiableObjectCount())
      .map(value => zio.aws.macie2.model.ObjectLevelStatistics.wrap(value))
    override val unclassifiableObjectSizeInBytes
        : Option[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly] = scala
      .Option(impl.unclassifiableObjectSizeInBytes())
      .map(value => zio.aws.macie2.model.ObjectLevelStatistics.wrap(value))
    override val versioning: Option[__boolean] =
      scala.Option(impl.versioning()).map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.BucketMetadata
  ): zio.aws.macie2.model.BucketMetadata.ReadOnly = new Wrapper(impl)
}
