package zio.aws.macie2.model
import scala.jdk.CollectionConverters._
sealed trait ScopeFilterKey {
  def unwrap: software.amazon.awssdk.services.macie2.model.ScopeFilterKey
}
object ScopeFilterKey {
  def wrap(
      value: software.amazon.awssdk.services.macie2.model.ScopeFilterKey
  ): zio.aws.macie2.model.ScopeFilterKey = value match {
    case software.amazon.awssdk.services.macie2.model.ScopeFilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.macie2.model.ScopeFilterKey.OBJECT_EXTENSION =>
      val r = OBJECT_EXTENSION
      r
    case software.amazon.awssdk.services.macie2.model.ScopeFilterKey.OBJECT_LAST_MODIFIED_DATE =>
      val r = OBJECT_LAST_MODIFIED_DATE
      r
    case software.amazon.awssdk.services.macie2.model.ScopeFilterKey.OBJECT_SIZE =>
      val r = OBJECT_SIZE
      r
    case software.amazon.awssdk.services.macie2.model.ScopeFilterKey.OBJECT_KEY =>
      val r = OBJECT_KEY
      r
  }
  case object unknownToSdkVersion extends zio.aws.macie2.model.ScopeFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.ScopeFilterKey =
      software.amazon.awssdk.services.macie2.model.ScopeFilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object OBJECT_EXTENSION extends zio.aws.macie2.model.ScopeFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.ScopeFilterKey =
      software.amazon.awssdk.services.macie2.model.ScopeFilterKey.OBJECT_EXTENSION
  }
  case object OBJECT_LAST_MODIFIED_DATE
      extends zio.aws.macie2.model.ScopeFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.ScopeFilterKey =
      software.amazon.awssdk.services.macie2.model.ScopeFilterKey.OBJECT_LAST_MODIFIED_DATE
  }
  case object OBJECT_SIZE extends zio.aws.macie2.model.ScopeFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.ScopeFilterKey =
      software.amazon.awssdk.services.macie2.model.ScopeFilterKey.OBJECT_SIZE
  }
  case object OBJECT_KEY extends zio.aws.macie2.model.ScopeFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.macie2.model.ScopeFilterKey =
      software.amazon.awssdk.services.macie2.model.ScopeFilterKey.OBJECT_KEY
  }
}
