package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class S3BucketDefinitionForJob(
    accountId: __string,
    buckets: Iterable[__string]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.S3BucketDefinitionForJob = {
    import S3BucketDefinitionForJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.S3BucketDefinitionForJob
      .builder()
      .accountId(__string.unwrap(accountId): java.lang.String)
      .buckets(buckets.map { item =>
        __string.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.S3BucketDefinitionForJob.ReadOnly =
    zio.aws.macie2.model.S3BucketDefinitionForJob.wrap(buildAwsValue())
}
object S3BucketDefinitionForJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.S3BucketDefinitionForJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.S3BucketDefinitionForJob =
      zio.aws.macie2.model.S3BucketDefinitionForJob(accountId, buckets)
    def accountId: __string
    def buckets: List[__string]
    def getAccountId: ZIO[Any, Nothing, __string] = ZIO.succeed(accountId)
    def getBuckets: ZIO[Any, Nothing, List[__string]] = ZIO.succeed(buckets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.S3BucketDefinitionForJob
  ) extends zio.aws.macie2.model.S3BucketDefinitionForJob.ReadOnly {
    override val accountId: __string =
      zio.aws.macie2.model.primitives.__string(impl.accountId())
    override val buckets: List[__string] = impl
      .buckets()
      .asScala
      .map { item =>
        zio.aws.macie2.model.primitives.__string(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.S3BucketDefinitionForJob
  ): zio.aws.macie2.model.S3BucketDefinitionForJob.ReadOnly = new Wrapper(impl)
}
