package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3BucketCriteriaForJob(
    excludes: Option[zio.aws.macie2.model.CriteriaBlockForJob] = None,
    includes: Option[zio.aws.macie2.model.CriteriaBlockForJob] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.S3BucketCriteriaForJob = {
    import S3BucketCriteriaForJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.S3BucketCriteriaForJob
      .builder()
      .optionallyWith(excludes.map(value => value.buildAwsValue()))(_.excludes)
      .optionallyWith(includes.map(value => value.buildAwsValue()))(_.includes)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.S3BucketCriteriaForJob.ReadOnly =
    zio.aws.macie2.model.S3BucketCriteriaForJob.wrap(buildAwsValue())
}
object S3BucketCriteriaForJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.S3BucketCriteriaForJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.S3BucketCriteriaForJob =
      zio.aws.macie2.model.S3BucketCriteriaForJob(
        excludes.map(value => value.asEditable),
        includes.map(value => value.asEditable)
      )
    def excludes: Option[zio.aws.macie2.model.CriteriaBlockForJob.ReadOnly]
    def includes: Option[zio.aws.macie2.model.CriteriaBlockForJob.ReadOnly]
    def getExcludes: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.CriteriaBlockForJob.ReadOnly
    ] = AwsError.unwrapOptionField("excludes", excludes)
    def getIncludes: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.CriteriaBlockForJob.ReadOnly
    ] = AwsError.unwrapOptionField("includes", includes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.S3BucketCriteriaForJob
  ) extends zio.aws.macie2.model.S3BucketCriteriaForJob.ReadOnly {
    override val excludes
        : Option[zio.aws.macie2.model.CriteriaBlockForJob.ReadOnly] = scala
      .Option(impl.excludes())
      .map(value => zio.aws.macie2.model.CriteriaBlockForJob.wrap(value))
    override val includes
        : Option[zio.aws.macie2.model.CriteriaBlockForJob.ReadOnly] = scala
      .Option(impl.includes())
      .map(value => zio.aws.macie2.model.CriteriaBlockForJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.S3BucketCriteriaForJob
  ): zio.aws.macie2.model.S3BucketCriteriaForJob.ReadOnly = new Wrapper(impl)
}
