package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class ClassificationResultStatus(
    code: Option[__string] = None,
    reason: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ClassificationResultStatus = {
    import ClassificationResultStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ClassificationResultStatus
      .builder()
      .optionallyWith(
        code.map(value => __string.unwrap(value): java.lang.String)
      )(_.code)
      .optionallyWith(
        reason.map(value => __string.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ClassificationResultStatus.ReadOnly =
    zio.aws.macie2.model.ClassificationResultStatus.wrap(buildAwsValue())
}
object ClassificationResultStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ClassificationResultStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ClassificationResultStatus =
      zio.aws.macie2.model.ClassificationResultStatus(
        code.map(value => value),
        reason.map(value => value)
      )
    def code: Option[__string]
    def reason: Option[__string]
    def getCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("code", code)
    def getReason: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ClassificationResultStatus
  ) extends zio.aws.macie2.model.ClassificationResultStatus.ReadOnly {
    override val code: Option[__string] = scala
      .Option(impl.code())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val reason: Option[__string] = scala
      .Option(impl.reason())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ClassificationResultStatus
  ): zio.aws.macie2.model.ClassificationResultStatus.ReadOnly = new Wrapper(
    impl
  )
}
