package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class AccountDetail(accountId: __string, email: __string) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.AccountDetail = {
    import AccountDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.AccountDetail
      .builder()
      .accountId(__string.unwrap(accountId): java.lang.String)
      .email(__string.unwrap(email): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.AccountDetail.ReadOnly =
    zio.aws.macie2.model.AccountDetail.wrap(buildAwsValue())
}
object AccountDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.AccountDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.AccountDetail =
      zio.aws.macie2.model.AccountDetail(accountId, email)
    def accountId: __string
    def email: __string
    def getAccountId: ZIO[Any, Nothing, __string] = ZIO.succeed(accountId)
    def getEmail: ZIO[Any, Nothing, __string] = ZIO.succeed(email)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.AccountDetail
  ) extends zio.aws.macie2.model.AccountDetail.ReadOnly {
    override val accountId: __string =
      zio.aws.macie2.model.primitives.__string(impl.accountId())
    override val email: __string =
      zio.aws.macie2.model.primitives.__string(impl.email())
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.AccountDetail
  ): zio.aws.macie2.model.AccountDetail.ReadOnly = new Wrapper(impl)
}
