package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class UsageStatisticsFilter(
    comparator: Option[zio.aws.macie2.model.UsageStatisticsFilterComparator] =
      None,
    key: Option[zio.aws.macie2.model.UsageStatisticsFilterKey] = None,
    values: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UsageStatisticsFilter = {
    import UsageStatisticsFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UsageStatisticsFilter
      .builder()
      .optionallyWith(comparator.map(value => value.unwrap))(_.comparator)
      .optionallyWith(key.map(value => value.unwrap))(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UsageStatisticsFilter.ReadOnly =
    zio.aws.macie2.model.UsageStatisticsFilter.wrap(buildAwsValue())
}
object UsageStatisticsFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UsageStatisticsFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UsageStatisticsFilter =
      zio.aws.macie2.model.UsageStatisticsFilter(
        comparator.map(value => value),
        key.map(value => value),
        values.map(value => value)
      )
    def comparator: Option[zio.aws.macie2.model.UsageStatisticsFilterComparator]
    def key: Option[zio.aws.macie2.model.UsageStatisticsFilterKey]
    def values: Option[List[__string]]
    def getComparator: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.UsageStatisticsFilterComparator
    ] = AwsError.unwrapOptionField("comparator", comparator)
    def getKey
        : ZIO[Any, AwsError, zio.aws.macie2.model.UsageStatisticsFilterKey] =
      AwsError.unwrapOptionField("key", key)
    def getValues: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UsageStatisticsFilter
  ) extends zio.aws.macie2.model.UsageStatisticsFilter.ReadOnly {
    override val comparator
        : Option[zio.aws.macie2.model.UsageStatisticsFilterComparator] = scala
      .Option(impl.comparator())
      .map(value =>
        zio.aws.macie2.model.UsageStatisticsFilterComparator.wrap(value)
      )
    override val key: Option[zio.aws.macie2.model.UsageStatisticsFilterKey] =
      scala
        .Option(impl.key())
        .map(value => zio.aws.macie2.model.UsageStatisticsFilterKey.wrap(value))
    override val values: Option[List[__string]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.primitives.__string(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UsageStatisticsFilter
  ): zio.aws.macie2.model.UsageStatisticsFilter.ReadOnly = new Wrapper(impl)
}
