package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Scoping(
    excludes: Option[zio.aws.macie2.model.JobScopingBlock] = None,
    includes: Option[zio.aws.macie2.model.JobScopingBlock] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.macie2.model.Scoping = {
    import Scoping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.Scoping
      .builder()
      .optionallyWith(excludes.map(value => value.buildAwsValue()))(_.excludes)
      .optionallyWith(includes.map(value => value.buildAwsValue()))(_.includes)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.Scoping.ReadOnly =
    zio.aws.macie2.model.Scoping.wrap(buildAwsValue())
}
object Scoping {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.Scoping] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.Scoping = zio.aws.macie2.model.Scoping(
      excludes.map(value => value.asEditable),
      includes.map(value => value.asEditable)
    )
    def excludes: Option[zio.aws.macie2.model.JobScopingBlock.ReadOnly]
    def includes: Option[zio.aws.macie2.model.JobScopingBlock.ReadOnly]
    def getExcludes
        : ZIO[Any, AwsError, zio.aws.macie2.model.JobScopingBlock.ReadOnly] =
      AwsError.unwrapOptionField("excludes", excludes)
    def getIncludes
        : ZIO[Any, AwsError, zio.aws.macie2.model.JobScopingBlock.ReadOnly] =
      AwsError.unwrapOptionField("includes", includes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.Scoping
  ) extends zio.aws.macie2.model.Scoping.ReadOnly {
    override val excludes
        : Option[zio.aws.macie2.model.JobScopingBlock.ReadOnly] = scala
      .Option(impl.excludes())
      .map(value => zio.aws.macie2.model.JobScopingBlock.wrap(value))
    override val includes
        : Option[zio.aws.macie2.model.JobScopingBlock.ReadOnly] = scala
      .Option(impl.includes())
      .map(value => zio.aws.macie2.model.JobScopingBlock.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.Scoping
  ): zio.aws.macie2.model.Scoping.ReadOnly = new Wrapper(impl)
}
