package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PolicyDetails(
    action: Option[zio.aws.macie2.model.FindingAction] = None,
    actor: Option[zio.aws.macie2.model.FindingActor] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.PolicyDetails = {
    import PolicyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.PolicyDetails
      .builder()
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .optionallyWith(actor.map(value => value.buildAwsValue()))(_.actor)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.PolicyDetails.ReadOnly =
    zio.aws.macie2.model.PolicyDetails.wrap(buildAwsValue())
}
object PolicyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.PolicyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.PolicyDetails =
      zio.aws.macie2.model.PolicyDetails(
        action.map(value => value.asEditable),
        actor.map(value => value.asEditable)
      )
    def action: Option[zio.aws.macie2.model.FindingAction.ReadOnly]
    def actor: Option[zio.aws.macie2.model.FindingActor.ReadOnly]
    def getAction
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingAction.ReadOnly] =
      AwsError.unwrapOptionField("action", action)
    def getActor
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingActor.ReadOnly] =
      AwsError.unwrapOptionField("actor", actor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.PolicyDetails
  ) extends zio.aws.macie2.model.PolicyDetails.ReadOnly {
    override val action: Option[zio.aws.macie2.model.FindingAction.ReadOnly] =
      scala
        .Option(impl.action())
        .map(value => zio.aws.macie2.model.FindingAction.wrap(value))
    override val actor: Option[zio.aws.macie2.model.FindingActor.ReadOnly] =
      scala
        .Option(impl.actor())
        .map(value => zio.aws.macie2.model.FindingActor.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.PolicyDetails
  ): zio.aws.macie2.model.PolicyDetails.ReadOnly = new Wrapper(impl)
}
