package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__long, __string}
import scala.jdk.CollectionConverters._
final case class CriterionAdditionalProperties(
    eq: Option[Iterable[__string]] = None,
    eqExactMatch: Option[Iterable[__string]] = None,
    gt: Option[__long] = None,
    gte: Option[__long] = None,
    lt: Option[__long] = None,
    lte: Option[__long] = None,
    neq: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CriterionAdditionalProperties = {
    import CriterionAdditionalProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CriterionAdditionalProperties
      .builder()
      .optionallyWith(
        eq.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.eq)
      .optionallyWith(
        eqExactMatch.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.eqExactMatch)
      .optionallyWith(gt.map(value => __long.unwrap(value): java.lang.Long))(
        _.gt
      )
      .optionallyWith(gte.map(value => __long.unwrap(value): java.lang.Long))(
        _.gte
      )
      .optionallyWith(lt.map(value => __long.unwrap(value): java.lang.Long))(
        _.lt
      )
      .optionallyWith(lte.map(value => __long.unwrap(value): java.lang.Long))(
        _.lte
      )
      .optionallyWith(
        neq.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.neq)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.CriterionAdditionalProperties.ReadOnly =
    zio.aws.macie2.model.CriterionAdditionalProperties.wrap(buildAwsValue())
}
object CriterionAdditionalProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CriterionAdditionalProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CriterionAdditionalProperties =
      zio.aws.macie2.model.CriterionAdditionalProperties(
        eq.map(value => value),
        eqExactMatch.map(value => value),
        gt.map(value => value),
        gte.map(value => value),
        lt.map(value => value),
        lte.map(value => value),
        neq.map(value => value)
      )
    def eq: Option[List[__string]]
    def eqExactMatch: Option[List[__string]]
    def gt: Option[__long]
    def gte: Option[__long]
    def lt: Option[__long]
    def lte: Option[__long]
    def neq: Option[List[__string]]
    def getEq: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("eq", eq)
    def getEqExactMatch: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("eqExactMatch", eqExactMatch)
    def getGt: ZIO[Any, AwsError, __long] = AwsError.unwrapOptionField("gt", gt)
    def getGte: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("gte", gte)
    def getLt: ZIO[Any, AwsError, __long] = AwsError.unwrapOptionField("lt", lt)
    def getLte: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("lte", lte)
    def getNeq: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("neq", neq)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CriterionAdditionalProperties
  ) extends zio.aws.macie2.model.CriterionAdditionalProperties.ReadOnly {
    override val eq: Option[List[__string]] = scala
      .Option(impl.eq())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.primitives.__string(item)
        }.toList
      )
    override val eqExactMatch: Option[List[__string]] = scala
      .Option(impl.eqExactMatch())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.primitives.__string(item)
        }.toList
      )
    override val gt: Option[__long] = scala
      .Option(impl.gt())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
    override val gte: Option[__long] = scala
      .Option(impl.gte())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
    override val lt: Option[__long] = scala
      .Option(impl.lt())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
    override val lte: Option[__long] = scala
      .Option(impl.lte())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
    override val neq: Option[List[__string]] = scala
      .Option(impl.neq())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.primitives.__string(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CriterionAdditionalProperties
  ): zio.aws.macie2.model.CriterionAdditionalProperties.ReadOnly = new Wrapper(
    impl
  )
}
