package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.macie2.model.primitives.__long
import scala.jdk.CollectionConverters._
final case class SeverityLevel(
    occurrencesThreshold: __long,
    severity: zio.aws.macie2.model.DataIdentifierSeverity
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SeverityLevel = {
    import SeverityLevel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SeverityLevel
      .builder()
      .occurrencesThreshold(__long.unwrap(occurrencesThreshold): java.lang.Long)
      .severity(severity.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SeverityLevel.ReadOnly =
    zio.aws.macie2.model.SeverityLevel.wrap(buildAwsValue())
}
object SeverityLevel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SeverityLevel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SeverityLevel =
      zio.aws.macie2.model.SeverityLevel(occurrencesThreshold, severity)
    def occurrencesThreshold: __long
    def severity: zio.aws.macie2.model.DataIdentifierSeverity
    def getOccurrencesThreshold: ZIO[Any, Nothing, __long] =
      ZIO.succeed(occurrencesThreshold)
    def getSeverity
        : ZIO[Any, Nothing, zio.aws.macie2.model.DataIdentifierSeverity] =
      ZIO.succeed(severity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SeverityLevel
  ) extends zio.aws.macie2.model.SeverityLevel.ReadOnly {
    override val occurrencesThreshold: __long =
      zio.aws.macie2.model.primitives.__long(impl.occurrencesThreshold())
    override val severity: zio.aws.macie2.model.DataIdentifierSeverity =
      zio.aws.macie2.model.DataIdentifierSeverity.wrap(impl.severity())
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SeverityLevel
  ): zio.aws.macie2.model.SeverityLevel.ReadOnly = new Wrapper(impl)
}
