package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3JobDefinition(
    bucketDefinitions: Option[
      Iterable[zio.aws.macie2.model.S3BucketDefinitionForJob]
    ] = None,
    scoping: Option[zio.aws.macie2.model.Scoping] = None,
    bucketCriteria: Option[zio.aws.macie2.model.S3BucketCriteriaForJob] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.S3JobDefinition = {
    import S3JobDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.S3JobDefinition
      .builder()
      .optionallyWith(
        bucketDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bucketDefinitions)
      .optionallyWith(scoping.map(value => value.buildAwsValue()))(_.scoping)
      .optionallyWith(bucketCriteria.map(value => value.buildAwsValue()))(
        _.bucketCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.S3JobDefinition.ReadOnly =
    zio.aws.macie2.model.S3JobDefinition.wrap(buildAwsValue())
}
object S3JobDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.S3JobDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.S3JobDefinition =
      zio.aws.macie2.model.S3JobDefinition(
        bucketDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scoping.map(value => value.asEditable),
        bucketCriteria.map(value => value.asEditable)
      )
    def bucketDefinitions
        : Option[List[zio.aws.macie2.model.S3BucketDefinitionForJob.ReadOnly]]
    def scoping: Option[zio.aws.macie2.model.Scoping.ReadOnly]
    def bucketCriteria
        : Option[zio.aws.macie2.model.S3BucketCriteriaForJob.ReadOnly]
    def getBucketDefinitions: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.S3BucketDefinitionForJob.ReadOnly
    ]] = AwsError.unwrapOptionField("bucketDefinitions", bucketDefinitions)
    def getScoping: ZIO[Any, AwsError, zio.aws.macie2.model.Scoping.ReadOnly] =
      AwsError.unwrapOptionField("scoping", scoping)
    def getBucketCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.S3BucketCriteriaForJob.ReadOnly
    ] = AwsError.unwrapOptionField("bucketCriteria", bucketCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.S3JobDefinition
  ) extends zio.aws.macie2.model.S3JobDefinition.ReadOnly {
    override val bucketDefinitions
        : Option[List[zio.aws.macie2.model.S3BucketDefinitionForJob.ReadOnly]] =
      scala
        .Option(impl.bucketDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.S3BucketDefinitionForJob.wrap(item)
          }.toList
        )
    override val scoping: Option[zio.aws.macie2.model.Scoping.ReadOnly] = scala
      .Option(impl.scoping())
      .map(value => zio.aws.macie2.model.Scoping.wrap(value))
    override val bucketCriteria
        : Option[zio.aws.macie2.model.S3BucketCriteriaForJob.ReadOnly] = scala
      .Option(impl.bucketCriteria())
      .map(value => zio.aws.macie2.model.S3BucketCriteriaForJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.S3JobDefinition
  ): zio.aws.macie2.model.S3JobDefinition.ReadOnly = new Wrapper(impl)
}
