package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class S3Destination(
    bucketName: __string,
    keyPrefix: Option[__string] = None,
    kmsKeyArn: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.S3Destination = {
    import S3Destination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.S3Destination
      .builder()
      .bucketName(__string.unwrap(bucketName): java.lang.String)
      .optionallyWith(
        keyPrefix.map(value => __string.unwrap(value): java.lang.String)
      )(_.keyPrefix)
      .kmsKeyArn(__string.unwrap(kmsKeyArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.S3Destination.ReadOnly =
    zio.aws.macie2.model.S3Destination.wrap(buildAwsValue())
}
object S3Destination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.S3Destination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.S3Destination = zio.aws.macie2.model
      .S3Destination(bucketName, keyPrefix.map(value => value), kmsKeyArn)
    def bucketName: __string
    def keyPrefix: Option[__string]
    def kmsKeyArn: __string
    def getBucketName: ZIO[Any, Nothing, __string] = ZIO.succeed(bucketName)
    def getKeyPrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("keyPrefix", keyPrefix)
    def getKmsKeyArn: ZIO[Any, Nothing, __string] = ZIO.succeed(kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.S3Destination
  ) extends zio.aws.macie2.model.S3Destination.ReadOnly {
    override val bucketName: __string =
      zio.aws.macie2.model.primitives.__string(impl.bucketName())
    override val keyPrefix: Option[__string] = scala
      .Option(impl.keyPrefix())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val kmsKeyArn: __string =
      zio.aws.macie2.model.primitives.__string(impl.kmsKeyArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.S3Destination
  ): zio.aws.macie2.model.S3Destination.ReadOnly = new Wrapper(impl)
}
