package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ResourcesAffected(
    s3Bucket: Option[zio.aws.macie2.model.S3Bucket] = None,
    s3Object: Option[zio.aws.macie2.model.S3Object] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ResourcesAffected = {
    import ResourcesAffected.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ResourcesAffected
      .builder()
      .optionallyWith(s3Bucket.map(value => value.buildAwsValue()))(_.s3Bucket)
      .optionallyWith(s3Object.map(value => value.buildAwsValue()))(_.s3Object)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.ResourcesAffected.ReadOnly =
    zio.aws.macie2.model.ResourcesAffected.wrap(buildAwsValue())
}
object ResourcesAffected {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ResourcesAffected
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ResourcesAffected =
      zio.aws.macie2.model.ResourcesAffected(
        s3Bucket.map(value => value.asEditable),
        s3Object.map(value => value.asEditable)
      )
    def s3Bucket: Option[zio.aws.macie2.model.S3Bucket.ReadOnly]
    def s3Object: Option[zio.aws.macie2.model.S3Object.ReadOnly]
    def getS3Bucket
        : ZIO[Any, AwsError, zio.aws.macie2.model.S3Bucket.ReadOnly] =
      AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getS3Object
        : ZIO[Any, AwsError, zio.aws.macie2.model.S3Object.ReadOnly] =
      AwsError.unwrapOptionField("s3Object", s3Object)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ResourcesAffected
  ) extends zio.aws.macie2.model.ResourcesAffected.ReadOnly {
    override val s3Bucket: Option[zio.aws.macie2.model.S3Bucket.ReadOnly] =
      scala
        .Option(impl.s3Bucket())
        .map(value => zio.aws.macie2.model.S3Bucket.wrap(value))
    override val s3Object: Option[zio.aws.macie2.model.S3Object.ReadOnly] =
      scala
        .Option(impl.s3Object())
        .map(value => zio.aws.macie2.model.S3Object.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ResourcesAffected
  ): zio.aws.macie2.model.ResourcesAffected.ReadOnly = new Wrapper(impl)
}
