package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateMacieSessionRequest(
    findingPublishingFrequency: Option[
      zio.aws.macie2.model.FindingPublishingFrequency
    ] = None,
    status: Option[zio.aws.macie2.model.MacieStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UpdateMacieSessionRequest = {
    import UpdateMacieSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UpdateMacieSessionRequest
      .builder()
      .optionallyWith(findingPublishingFrequency.map(value => value.unwrap))(
        _.findingPublishingFrequency
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UpdateMacieSessionRequest.ReadOnly =
    zio.aws.macie2.model.UpdateMacieSessionRequest.wrap(buildAwsValue())
}
object UpdateMacieSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UpdateMacieSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UpdateMacieSessionRequest =
      zio.aws.macie2.model.UpdateMacieSessionRequest(
        findingPublishingFrequency.map(value => value),
        status.map(value => value)
      )
    def findingPublishingFrequency
        : Option[zio.aws.macie2.model.FindingPublishingFrequency]
    def status: Option[zio.aws.macie2.model.MacieStatus]
    def getFindingPublishingFrequency
        : ZIO[Any, AwsError, zio.aws.macie2.model.FindingPublishingFrequency] =
      AwsError.unwrapOptionField(
        "findingPublishingFrequency",
        findingPublishingFrequency
      )
    def getStatus: ZIO[Any, AwsError, zio.aws.macie2.model.MacieStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UpdateMacieSessionRequest
  ) extends zio.aws.macie2.model.UpdateMacieSessionRequest.ReadOnly {
    override val findingPublishingFrequency
        : Option[zio.aws.macie2.model.FindingPublishingFrequency] = scala
      .Option(impl.findingPublishingFrequency())
      .map(value => zio.aws.macie2.model.FindingPublishingFrequency.wrap(value))
    override val status: Option[zio.aws.macie2.model.MacieStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.macie2.model.MacieStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UpdateMacieSessionRequest
  ): zio.aws.macie2.model.UpdateMacieSessionRequest.ReadOnly = new Wrapper(impl)
}
