package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClassificationExportConfiguration(
    s3Destination: Option[zio.aws.macie2.model.S3Destination] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.ClassificationExportConfiguration = {
    import ClassificationExportConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.ClassificationExportConfiguration
      .builder()
      .optionallyWith(s3Destination.map(value => value.buildAwsValue()))(
        _.s3Destination
      )
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.ClassificationExportConfiguration.ReadOnly =
    zio.aws.macie2.model.ClassificationExportConfiguration.wrap(buildAwsValue())
}
object ClassificationExportConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.ClassificationExportConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.ClassificationExportConfiguration =
      zio.aws.macie2.model.ClassificationExportConfiguration(
        s3Destination.map(value => value.asEditable)
      )
    def s3Destination: Option[zio.aws.macie2.model.S3Destination.ReadOnly]
    def getS3Destination
        : ZIO[Any, AwsError, zio.aws.macie2.model.S3Destination.ReadOnly] =
      AwsError.unwrapOptionField("s3Destination", s3Destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.ClassificationExportConfiguration
  ) extends zio.aws.macie2.model.ClassificationExportConfiguration.ReadOnly {
    override val s3Destination
        : Option[zio.aws.macie2.model.S3Destination.ReadOnly] = scala
      .Option(impl.s3Destination())
      .map(value => zio.aws.macie2.model.S3Destination.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.ClassificationExportConfiguration
  ): zio.aws.macie2.model.ClassificationExportConfiguration.ReadOnly =
    new Wrapper(impl)
}
