package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__string, __timestampIso8601}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class UserPausedDetails(
    jobExpiresAt: Option[__timestampIso8601] = None,
    jobImminentExpirationHealthEventArn: Option[__string] = None,
    jobPausedAt: Option[__timestampIso8601] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.UserPausedDetails = {
    import UserPausedDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.UserPausedDetails
      .builder()
      .optionallyWith(
        jobExpiresAt.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.jobExpiresAt)
      .optionallyWith(
        jobImminentExpirationHealthEventArn.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.jobImminentExpirationHealthEventArn)
      .optionallyWith(
        jobPausedAt.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.jobPausedAt)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.UserPausedDetails.ReadOnly =
    zio.aws.macie2.model.UserPausedDetails.wrap(buildAwsValue())
}
object UserPausedDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.UserPausedDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.UserPausedDetails =
      zio.aws.macie2.model.UserPausedDetails(
        jobExpiresAt.map(value => value),
        jobImminentExpirationHealthEventArn.map(value => value),
        jobPausedAt.map(value => value)
      )
    def jobExpiresAt: Option[__timestampIso8601]
    def jobImminentExpirationHealthEventArn: Option[__string]
    def jobPausedAt: Option[__timestampIso8601]
    def getJobExpiresAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("jobExpiresAt", jobExpiresAt)
    def getJobImminentExpirationHealthEventArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "jobImminentExpirationHealthEventArn",
        jobImminentExpirationHealthEventArn
      )
    def getJobPausedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("jobPausedAt", jobPausedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.UserPausedDetails
  ) extends zio.aws.macie2.model.UserPausedDetails.ReadOnly {
    override val jobExpiresAt: Option[__timestampIso8601] = scala
      .Option(impl.jobExpiresAt())
      .map(value => zio.aws.macie2.model.primitives.__timestampIso8601(value))
    override val jobImminentExpirationHealthEventArn: Option[__string] = scala
      .Option(impl.jobImminentExpirationHealthEventArn())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val jobPausedAt: Option[__timestampIso8601] = scala
      .Option(impl.jobPausedAt())
      .map(value => zio.aws.macie2.model.primitives.__timestampIso8601(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.UserPausedDetails
  ): zio.aws.macie2.model.UserPausedDetails.ReadOnly = new Wrapper(impl)
}
