package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__boolean, __string}
import scala.jdk.CollectionConverters._
final case class CreateInvitationsRequest(
    accountIds: Iterable[__string],
    disableEmailNotification: Option[__boolean] = None,
    message: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CreateInvitationsRequest = {
    import CreateInvitationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CreateInvitationsRequest
      .builder()
      .accountIds(accountIds.map { item =>
        __string.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        disableEmailNotification.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.disableEmailNotification)
      .optionallyWith(
        message.map(value => __string.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.CreateInvitationsRequest.ReadOnly =
    zio.aws.macie2.model.CreateInvitationsRequest.wrap(buildAwsValue())
}
object CreateInvitationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CreateInvitationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CreateInvitationsRequest =
      zio.aws.macie2.model.CreateInvitationsRequest(
        accountIds,
        disableEmailNotification.map(value => value),
        message.map(value => value)
      )
    def accountIds: List[__string]
    def disableEmailNotification: Option[__boolean]
    def message: Option[__string]
    def getAccountIds: ZIO[Any, Nothing, List[__string]] =
      ZIO.succeed(accountIds)
    def getDisableEmailNotification: ZIO[Any, AwsError, __boolean] = AwsError
      .unwrapOptionField("disableEmailNotification", disableEmailNotification)
    def getMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CreateInvitationsRequest
  ) extends zio.aws.macie2.model.CreateInvitationsRequest.ReadOnly {
    override val accountIds: List[__string] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.macie2.model.primitives.__string(item)
      }
      .toList
    override val disableEmailNotification: Option[__boolean] = scala
      .Option(impl.disableEmailNotification())
      .map(value => zio.aws.macie2.model.primitives.__boolean(value))
    override val message: Option[__string] = scala
      .Option(impl.message())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CreateInvitationsRequest
  ): zio.aws.macie2.model.CreateInvitationsRequest.ReadOnly = new Wrapper(impl)
}
