package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__timestampIso8601, __long}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetBucketStatisticsResponse(
    bucketCount: Option[__long] = None,
    bucketCountByEffectivePermission: Option[
      zio.aws.macie2.model.BucketCountByEffectivePermission
    ] = None,
    bucketCountByEncryptionType: Option[
      zio.aws.macie2.model.BucketCountByEncryptionType
    ] = None,
    bucketCountByObjectEncryptionRequirement: Option[
      zio.aws.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads
    ] = None,
    bucketCountBySharedAccessType: Option[
      zio.aws.macie2.model.BucketCountBySharedAccessType
    ] = None,
    classifiableObjectCount: Option[__long] = None,
    classifiableSizeInBytes: Option[__long] = None,
    lastUpdated: Option[__timestampIso8601] = None,
    objectCount: Option[__long] = None,
    sizeInBytes: Option[__long] = None,
    sizeInBytesCompressed: Option[__long] = None,
    unclassifiableObjectCount: Option[
      zio.aws.macie2.model.ObjectLevelStatistics
    ] = None,
    unclassifiableObjectSizeInBytes: Option[
      zio.aws.macie2.model.ObjectLevelStatistics
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetBucketStatisticsResponse = {
    import GetBucketStatisticsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetBucketStatisticsResponse
      .builder()
      .optionallyWith(
        bucketCount.map(value => __long.unwrap(value): java.lang.Long)
      )(_.bucketCount)
      .optionallyWith(
        bucketCountByEffectivePermission.map(value => value.buildAwsValue())
      )(_.bucketCountByEffectivePermission)
      .optionallyWith(
        bucketCountByEncryptionType.map(value => value.buildAwsValue())
      )(_.bucketCountByEncryptionType)
      .optionallyWith(
        bucketCountByObjectEncryptionRequirement.map(value =>
          value.buildAwsValue()
        )
      )(_.bucketCountByObjectEncryptionRequirement)
      .optionallyWith(
        bucketCountBySharedAccessType.map(value => value.buildAwsValue())
      )(_.bucketCountBySharedAccessType)
      .optionallyWith(
        classifiableObjectCount.map(value =>
          __long.unwrap(value): java.lang.Long
        )
      )(_.classifiableObjectCount)
      .optionallyWith(
        classifiableSizeInBytes.map(value =>
          __long.unwrap(value): java.lang.Long
        )
      )(_.classifiableSizeInBytes)
      .optionallyWith(
        lastUpdated.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.lastUpdated)
      .optionallyWith(
        objectCount.map(value => __long.unwrap(value): java.lang.Long)
      )(_.objectCount)
      .optionallyWith(
        sizeInBytes.map(value => __long.unwrap(value): java.lang.Long)
      )(_.sizeInBytes)
      .optionallyWith(
        sizeInBytesCompressed.map(value => __long.unwrap(value): java.lang.Long)
      )(_.sizeInBytesCompressed)
      .optionallyWith(
        unclassifiableObjectCount.map(value => value.buildAwsValue())
      )(_.unclassifiableObjectCount)
      .optionallyWith(
        unclassifiableObjectSizeInBytes.map(value => value.buildAwsValue())
      )(_.unclassifiableObjectSizeInBytes)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetBucketStatisticsResponse.ReadOnly =
    zio.aws.macie2.model.GetBucketStatisticsResponse.wrap(buildAwsValue())
}
object GetBucketStatisticsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetBucketStatisticsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetBucketStatisticsResponse =
      zio.aws.macie2.model.GetBucketStatisticsResponse(
        bucketCount.map(value => value),
        bucketCountByEffectivePermission.map(value => value.asEditable),
        bucketCountByEncryptionType.map(value => value.asEditable),
        bucketCountByObjectEncryptionRequirement.map(value => value.asEditable),
        bucketCountBySharedAccessType.map(value => value.asEditable),
        classifiableObjectCount.map(value => value),
        classifiableSizeInBytes.map(value => value),
        lastUpdated.map(value => value),
        objectCount.map(value => value),
        sizeInBytes.map(value => value),
        sizeInBytesCompressed.map(value => value),
        unclassifiableObjectCount.map(value => value.asEditable),
        unclassifiableObjectSizeInBytes.map(value => value.asEditable)
      )
    def bucketCount: Option[__long]
    def bucketCountByEffectivePermission
        : Option[zio.aws.macie2.model.BucketCountByEffectivePermission.ReadOnly]
    def bucketCountByEncryptionType
        : Option[zio.aws.macie2.model.BucketCountByEncryptionType.ReadOnly]
    def bucketCountByObjectEncryptionRequirement: Option[
      zio.aws.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads.ReadOnly
    ]
    def bucketCountBySharedAccessType
        : Option[zio.aws.macie2.model.BucketCountBySharedAccessType.ReadOnly]
    def classifiableObjectCount: Option[__long]
    def classifiableSizeInBytes: Option[__long]
    def lastUpdated: Option[__timestampIso8601]
    def objectCount: Option[__long]
    def sizeInBytes: Option[__long]
    def sizeInBytesCompressed: Option[__long]
    def unclassifiableObjectCount
        : Option[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly]
    def unclassifiableObjectSizeInBytes
        : Option[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly]
    def getBucketCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("bucketCount", bucketCount)
    def getBucketCountByEffectivePermission: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.BucketCountByEffectivePermission.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketCountByEffectivePermission",
      bucketCountByEffectivePermission
    )
    def getBucketCountByEncryptionType: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.BucketCountByEncryptionType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketCountByEncryptionType",
      bucketCountByEncryptionType
    )
    def getBucketCountByObjectEncryptionRequirement: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketCountByObjectEncryptionRequirement",
      bucketCountByObjectEncryptionRequirement
    )
    def getBucketCountBySharedAccessType: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.BucketCountBySharedAccessType.ReadOnly
    ] = AwsError.unwrapOptionField(
      "bucketCountBySharedAccessType",
      bucketCountBySharedAccessType
    )
    def getClassifiableObjectCount: ZIO[Any, AwsError, __long] = AwsError
      .unwrapOptionField("classifiableObjectCount", classifiableObjectCount)
    def getClassifiableSizeInBytes: ZIO[Any, AwsError, __long] = AwsError
      .unwrapOptionField("classifiableSizeInBytes", classifiableSizeInBytes)
    def getLastUpdated: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getObjectCount: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("objectCount", objectCount)
    def getSizeInBytes: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("sizeInBytes", sizeInBytes)
    def getSizeInBytesCompressed: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("sizeInBytesCompressed", sizeInBytesCompressed)
    def getUnclassifiableObjectCount: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "unclassifiableObjectCount",
      unclassifiableObjectCount
    )
    def getUnclassifiableObjectSizeInBytes: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "unclassifiableObjectSizeInBytes",
      unclassifiableObjectSizeInBytes
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetBucketStatisticsResponse
  ) extends zio.aws.macie2.model.GetBucketStatisticsResponse.ReadOnly {
    override val bucketCount: Option[__long] = scala
      .Option(impl.bucketCount())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
    override val bucketCountByEffectivePermission: Option[
      zio.aws.macie2.model.BucketCountByEffectivePermission.ReadOnly
    ] = scala
      .Option(impl.bucketCountByEffectivePermission())
      .map(value =>
        zio.aws.macie2.model.BucketCountByEffectivePermission.wrap(value)
      )
    override val bucketCountByEncryptionType
        : Option[zio.aws.macie2.model.BucketCountByEncryptionType.ReadOnly] =
      scala
        .Option(impl.bucketCountByEncryptionType())
        .map(value =>
          zio.aws.macie2.model.BucketCountByEncryptionType.wrap(value)
        )
    override val bucketCountByObjectEncryptionRequirement: Option[
      zio.aws.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads.ReadOnly
    ] = scala
      .Option(impl.bucketCountByObjectEncryptionRequirement())
      .map(value =>
        zio.aws.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads
          .wrap(value)
      )
    override val bucketCountBySharedAccessType
        : Option[zio.aws.macie2.model.BucketCountBySharedAccessType.ReadOnly] =
      scala
        .Option(impl.bucketCountBySharedAccessType())
        .map(value =>
          zio.aws.macie2.model.BucketCountBySharedAccessType.wrap(value)
        )
    override val classifiableObjectCount: Option[__long] = scala
      .Option(impl.classifiableObjectCount())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
    override val classifiableSizeInBytes: Option[__long] = scala
      .Option(impl.classifiableSizeInBytes())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
    override val lastUpdated: Option[__timestampIso8601] = scala
      .Option(impl.lastUpdated())
      .map(value => zio.aws.macie2.model.primitives.__timestampIso8601(value))
    override val objectCount: Option[__long] = scala
      .Option(impl.objectCount())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
    override val sizeInBytes: Option[__long] = scala
      .Option(impl.sizeInBytes())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
    override val sizeInBytesCompressed: Option[__long] = scala
      .Option(impl.sizeInBytesCompressed())
      .map(value => zio.aws.macie2.model.primitives.__long(value))
    override val unclassifiableObjectCount
        : Option[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly] = scala
      .Option(impl.unclassifiableObjectCount())
      .map(value => zio.aws.macie2.model.ObjectLevelStatistics.wrap(value))
    override val unclassifiableObjectSizeInBytes
        : Option[zio.aws.macie2.model.ObjectLevelStatistics.ReadOnly] = scala
      .Option(impl.unclassifiableObjectSizeInBytes())
      .map(value => zio.aws.macie2.model.ObjectLevelStatistics.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetBucketStatisticsResponse
  ): zio.aws.macie2.model.GetBucketStatisticsResponse.ReadOnly = new Wrapper(
    impl
  )
}
