package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class EnableOrganizationAdminAccountRequest(
    adminAccountId: __string,
    clientToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.EnableOrganizationAdminAccountRequest = {
    import EnableOrganizationAdminAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.EnableOrganizationAdminAccountRequest
      .builder()
      .adminAccountId(__string.unwrap(adminAccountId): java.lang.String)
      .optionallyWith(
        clientToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.EnableOrganizationAdminAccountRequest.ReadOnly =
    zio.aws.macie2.model.EnableOrganizationAdminAccountRequest
      .wrap(buildAwsValue())
}
object EnableOrganizationAdminAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.EnableOrganizationAdminAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.EnableOrganizationAdminAccountRequest =
      zio.aws.macie2.model.EnableOrganizationAdminAccountRequest(
        adminAccountId,
        clientToken.map(value => value)
      )
    def adminAccountId: __string
    def clientToken: Option[__string]
    def getAdminAccountId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(adminAccountId)
    def getClientToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.EnableOrganizationAdminAccountRequest
  ) extends zio.aws.macie2.model.EnableOrganizationAdminAccountRequest.ReadOnly {
    override val adminAccountId: __string =
      zio.aws.macie2.model.primitives.__string(impl.adminAccountId())
    override val clientToken: Option[__string] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.EnableOrganizationAdminAccountRequest
  ): zio.aws.macie2.model.EnableOrganizationAdminAccountRequest.ReadOnly =
    new Wrapper(impl)
}
