package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CriteriaForJob(
    simpleCriterion: Option[zio.aws.macie2.model.SimpleCriterionForJob] = None,
    tagCriterion: Option[zio.aws.macie2.model.TagCriterionForJob] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CriteriaForJob = {
    import CriteriaForJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CriteriaForJob
      .builder()
      .optionallyWith(simpleCriterion.map(value => value.buildAwsValue()))(
        _.simpleCriterion
      )
      .optionallyWith(tagCriterion.map(value => value.buildAwsValue()))(
        _.tagCriterion
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.CriteriaForJob.ReadOnly =
    zio.aws.macie2.model.CriteriaForJob.wrap(buildAwsValue())
}
object CriteriaForJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CriteriaForJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CriteriaForJob =
      zio.aws.macie2.model.CriteriaForJob(
        simpleCriterion.map(value => value.asEditable),
        tagCriterion.map(value => value.asEditable)
      )
    def simpleCriterion
        : Option[zio.aws.macie2.model.SimpleCriterionForJob.ReadOnly]
    def tagCriterion: Option[zio.aws.macie2.model.TagCriterionForJob.ReadOnly]
    def getSimpleCriterion: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.SimpleCriterionForJob.ReadOnly
    ] = AwsError.unwrapOptionField("simpleCriterion", simpleCriterion)
    def getTagCriterion
        : ZIO[Any, AwsError, zio.aws.macie2.model.TagCriterionForJob.ReadOnly] =
      AwsError.unwrapOptionField("tagCriterion", tagCriterion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CriteriaForJob
  ) extends zio.aws.macie2.model.CriteriaForJob.ReadOnly {
    override val simpleCriterion
        : Option[zio.aws.macie2.model.SimpleCriterionForJob.ReadOnly] = scala
      .Option(impl.simpleCriterion())
      .map(value => zio.aws.macie2.model.SimpleCriterionForJob.wrap(value))
    override val tagCriterion
        : Option[zio.aws.macie2.model.TagCriterionForJob.ReadOnly] = scala
      .Option(impl.tagCriterion())
      .map(value => zio.aws.macie2.model.TagCriterionForJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CriteriaForJob
  ): zio.aws.macie2.model.CriteriaForJob.ReadOnly = new Wrapper(impl)
}
