package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class TagValuePair(
    key: Option[__string] = None,
    value: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.TagValuePair = {
    import TagValuePair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.TagValuePair
      .builder()
      .optionallyWith(
        key.map(value => __string.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value => __string.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.TagValuePair.ReadOnly =
    zio.aws.macie2.model.TagValuePair.wrap(buildAwsValue())
}
object TagValuePair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.TagValuePair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.TagValuePair = zio.aws.macie2.model
      .TagValuePair(key.map(value => value), value.map(value => value))
    def key: Option[__string]
    def value: Option[__string]
    def getKey: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.TagValuePair
  ) extends zio.aws.macie2.model.TagValuePair.ReadOnly {
    override val key: Option[__string] = scala
      .Option(impl.key())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val value: Option[__string] = scala
      .Option(impl.value())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.TagValuePair
  ): zio.aws.macie2.model.TagValuePair.ReadOnly = new Wrapper(impl)
}
