package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class DescribeBucketsResponse(
    buckets: Option[Iterable[zio.aws.macie2.model.BucketMetadata]] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.DescribeBucketsResponse = {
    import DescribeBucketsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.DescribeBucketsResponse
      .builder()
      .optionallyWith(
        buckets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.buckets)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.DescribeBucketsResponse.ReadOnly =
    zio.aws.macie2.model.DescribeBucketsResponse.wrap(buildAwsValue())
}
object DescribeBucketsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.DescribeBucketsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.DescribeBucketsResponse =
      zio.aws.macie2.model.DescribeBucketsResponse(
        buckets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def buckets: Option[List[zio.aws.macie2.model.BucketMetadata.ReadOnly]]
    def nextToken: Option[__string]
    def getBuckets: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.BucketMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("buckets", buckets)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.DescribeBucketsResponse
  ) extends zio.aws.macie2.model.DescribeBucketsResponse.ReadOnly {
    override val buckets
        : Option[List[zio.aws.macie2.model.BucketMetadata.ReadOnly]] = scala
      .Option(impl.buckets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.BucketMetadata.wrap(item)
        }.toList
      )
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.DescribeBucketsResponse
  ): zio.aws.macie2.model.DescribeBucketsResponse.ReadOnly = new Wrapper(impl)
}
