package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__string, __timestampIso8601}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class JobSummary(
    bucketDefinitions: Option[
      Iterable[zio.aws.macie2.model.S3BucketDefinitionForJob]
    ] = None,
    createdAt: Option[__timestampIso8601] = None,
    jobId: Option[__string] = None,
    jobStatus: Option[zio.aws.macie2.model.JobStatus] = None,
    jobType: Option[zio.aws.macie2.model.JobType] = None,
    lastRunErrorStatus: Option[zio.aws.macie2.model.LastRunErrorStatus] = None,
    name: Option[__string] = None,
    userPausedDetails: Option[zio.aws.macie2.model.UserPausedDetails] = None,
    bucketCriteria: Option[zio.aws.macie2.model.S3BucketCriteriaForJob] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.JobSummary = {
    import JobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.JobSummary
      .builder()
      .optionallyWith(
        bucketDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bucketDefinitions)
      .optionallyWith(
        createdAt.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.createdAt)
      .optionallyWith(
        jobId.map(value => __string.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(jobType.map(value => value.unwrap))(_.jobType)
      .optionallyWith(lastRunErrorStatus.map(value => value.buildAwsValue()))(
        _.lastRunErrorStatus
      )
      .optionallyWith(
        name.map(value => __string.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(userPausedDetails.map(value => value.buildAwsValue()))(
        _.userPausedDetails
      )
      .optionallyWith(bucketCriteria.map(value => value.buildAwsValue()))(
        _.bucketCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.JobSummary.ReadOnly =
    zio.aws.macie2.model.JobSummary.wrap(buildAwsValue())
}
object JobSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.JobSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.JobSummary =
      zio.aws.macie2.model.JobSummary(
        bucketDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdAt.map(value => value),
        jobId.map(value => value),
        jobStatus.map(value => value),
        jobType.map(value => value),
        lastRunErrorStatus.map(value => value.asEditable),
        name.map(value => value),
        userPausedDetails.map(value => value.asEditable),
        bucketCriteria.map(value => value.asEditable)
      )
    def bucketDefinitions
        : Option[List[zio.aws.macie2.model.S3BucketDefinitionForJob.ReadOnly]]
    def createdAt: Option[__timestampIso8601]
    def jobId: Option[__string]
    def jobStatus: Option[zio.aws.macie2.model.JobStatus]
    def jobType: Option[zio.aws.macie2.model.JobType]
    def lastRunErrorStatus
        : Option[zio.aws.macie2.model.LastRunErrorStatus.ReadOnly]
    def name: Option[__string]
    def userPausedDetails
        : Option[zio.aws.macie2.model.UserPausedDetails.ReadOnly]
    def bucketCriteria
        : Option[zio.aws.macie2.model.S3BucketCriteriaForJob.ReadOnly]
    def getBucketDefinitions: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.S3BucketDefinitionForJob.ReadOnly
    ]] = AwsError.unwrapOptionField("bucketDefinitions", bucketDefinitions)
    def getCreatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getJobId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.macie2.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getJobType: ZIO[Any, AwsError, zio.aws.macie2.model.JobType] =
      AwsError.unwrapOptionField("jobType", jobType)
    def getLastRunErrorStatus
        : ZIO[Any, AwsError, zio.aws.macie2.model.LastRunErrorStatus.ReadOnly] =
      AwsError.unwrapOptionField("lastRunErrorStatus", lastRunErrorStatus)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getUserPausedDetails
        : ZIO[Any, AwsError, zio.aws.macie2.model.UserPausedDetails.ReadOnly] =
      AwsError.unwrapOptionField("userPausedDetails", userPausedDetails)
    def getBucketCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.macie2.model.S3BucketCriteriaForJob.ReadOnly
    ] = AwsError.unwrapOptionField("bucketCriteria", bucketCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.JobSummary
  ) extends zio.aws.macie2.model.JobSummary.ReadOnly {
    override val bucketDefinitions
        : Option[List[zio.aws.macie2.model.S3BucketDefinitionForJob.ReadOnly]] =
      scala
        .Option(impl.bucketDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.S3BucketDefinitionForJob.wrap(item)
          }.toList
        )
    override val createdAt: Option[__timestampIso8601] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.macie2.model.primitives.__timestampIso8601(value))
    override val jobId: Option[__string] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val jobStatus: Option[zio.aws.macie2.model.JobStatus] = scala
      .Option(impl.jobStatus())
      .map(value => zio.aws.macie2.model.JobStatus.wrap(value))
    override val jobType: Option[zio.aws.macie2.model.JobType] = scala
      .Option(impl.jobType())
      .map(value => zio.aws.macie2.model.JobType.wrap(value))
    override val lastRunErrorStatus
        : Option[zio.aws.macie2.model.LastRunErrorStatus.ReadOnly] = scala
      .Option(impl.lastRunErrorStatus())
      .map(value => zio.aws.macie2.model.LastRunErrorStatus.wrap(value))
    override val name: Option[__string] = scala
      .Option(impl.name())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val userPausedDetails
        : Option[zio.aws.macie2.model.UserPausedDetails.ReadOnly] = scala
      .Option(impl.userPausedDetails())
      .map(value => zio.aws.macie2.model.UserPausedDetails.wrap(value))
    override val bucketCriteria
        : Option[zio.aws.macie2.model.S3BucketCriteriaForJob.ReadOnly] = scala
      .Option(impl.bucketCriteria())
      .map(value => zio.aws.macie2.model.S3BucketCriteriaForJob.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.JobSummary
  ): zio.aws.macie2.model.JobSummary.ReadOnly = new Wrapper(impl)
}
