package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__timestampIso8601, __string}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Invitation(
    accountId: Option[__string] = None,
    invitationId: Option[__string] = None,
    invitedAt: Option[__timestampIso8601] = None,
    relationshipStatus: Option[zio.aws.macie2.model.RelationshipStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.Invitation = {
    import Invitation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.Invitation
      .builder()
      .optionallyWith(
        accountId.map(value => __string.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        invitationId.map(value => __string.unwrap(value): java.lang.String)
      )(_.invitationId)
      .optionallyWith(
        invitedAt.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.invitedAt)
      .optionallyWith(relationshipStatus.map(value => value.unwrap))(
        _.relationshipStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.Invitation.ReadOnly =
    zio.aws.macie2.model.Invitation.wrap(buildAwsValue())
}
object Invitation {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.macie2.model.Invitation] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.Invitation =
      zio.aws.macie2.model.Invitation(
        accountId.map(value => value),
        invitationId.map(value => value),
        invitedAt.map(value => value),
        relationshipStatus.map(value => value)
      )
    def accountId: Option[__string]
    def invitationId: Option[__string]
    def invitedAt: Option[__timestampIso8601]
    def relationshipStatus: Option[zio.aws.macie2.model.RelationshipStatus]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getInvitationId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("invitationId", invitationId)
    def getInvitedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("invitedAt", invitedAt)
    def getRelationshipStatus
        : ZIO[Any, AwsError, zio.aws.macie2.model.RelationshipStatus] =
      AwsError.unwrapOptionField("relationshipStatus", relationshipStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.Invitation
  ) extends zio.aws.macie2.model.Invitation.ReadOnly {
    override val accountId: Option[__string] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val invitationId: Option[__string] = scala
      .Option(impl.invitationId())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val invitedAt: Option[__timestampIso8601] = scala
      .Option(impl.invitedAt())
      .map(value => zio.aws.macie2.model.primitives.__timestampIso8601(value))
    override val relationshipStatus
        : Option[zio.aws.macie2.model.RelationshipStatus] = scala
      .Option(impl.relationshipStatus())
      .map(value => zio.aws.macie2.model.RelationshipStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.Invitation
  ): zio.aws.macie2.model.Invitation.ReadOnly = new Wrapper(impl)
}
