package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__timestampIso8601, __string}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetMemberResponse(
    accountId: Option[__string] = None,
    administratorAccountId: Option[__string] = None,
    arn: Option[__string] = None,
    email: Option[__string] = None,
    invitedAt: Option[__timestampIso8601] = None,
    masterAccountId: Option[__string] = None,
    relationshipStatus: Option[zio.aws.macie2.model.RelationshipStatus] = None,
    tags: Option[Map[__string, __string]] = None,
    updatedAt: Option[__timestampIso8601] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetMemberResponse = {
    import GetMemberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetMemberResponse
      .builder()
      .optionallyWith(
        accountId.map(value => __string.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        administratorAccountId.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.administratorAccountId)
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        email.map(value => __string.unwrap(value): java.lang.String)
      )(_.email)
      .optionallyWith(
        invitedAt.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.invitedAt)
      .optionallyWith(
        masterAccountId.map(value => __string.unwrap(value): java.lang.String)
      )(_.masterAccountId)
      .optionallyWith(relationshipStatus.map(value => value.unwrap))(
        _.relationshipStatus
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        updatedAt.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.updatedAt)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.GetMemberResponse.ReadOnly =
    zio.aws.macie2.model.GetMemberResponse.wrap(buildAwsValue())
}
object GetMemberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetMemberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetMemberResponse =
      zio.aws.macie2.model.GetMemberResponse(
        accountId.map(value => value),
        administratorAccountId.map(value => value),
        arn.map(value => value),
        email.map(value => value),
        invitedAt.map(value => value),
        masterAccountId.map(value => value),
        relationshipStatus.map(value => value),
        tags.map(value => value),
        updatedAt.map(value => value)
      )
    def accountId: Option[__string]
    def administratorAccountId: Option[__string]
    def arn: Option[__string]
    def email: Option[__string]
    def invitedAt: Option[__timestampIso8601]
    def masterAccountId: Option[__string]
    def relationshipStatus: Option[zio.aws.macie2.model.RelationshipStatus]
    def tags: Option[Map[__string, __string]]
    def updatedAt: Option[__timestampIso8601]
    def getAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAdministratorAccountId: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("administratorAccountId", administratorAccountId)
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getEmail: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("email", email)
    def getInvitedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("invitedAt", invitedAt)
    def getMasterAccountId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("masterAccountId", masterAccountId)
    def getRelationshipStatus
        : ZIO[Any, AwsError, zio.aws.macie2.model.RelationshipStatus] =
      AwsError.unwrapOptionField("relationshipStatus", relationshipStatus)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetMemberResponse
  ) extends zio.aws.macie2.model.GetMemberResponse.ReadOnly {
    override val accountId: Option[__string] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val administratorAccountId: Option[__string] = scala
      .Option(impl.administratorAccountId())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val email: Option[__string] = scala
      .Option(impl.email())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val invitedAt: Option[__timestampIso8601] = scala
      .Option(impl.invitedAt())
      .map(value => zio.aws.macie2.model.primitives.__timestampIso8601(value))
    override val masterAccountId: Option[__string] = scala
      .Option(impl.masterAccountId())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val relationshipStatus
        : Option[zio.aws.macie2.model.RelationshipStatus] = scala
      .Option(impl.relationshipStatus())
      .map(value => zio.aws.macie2.model.RelationshipStatus.wrap(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.macie2.model.primitives
              .__string(key) -> zio.aws.macie2.model.primitives.__string(value)
          })
          .toMap
      )
    override val updatedAt: Option[__timestampIso8601] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.macie2.model.primitives.__timestampIso8601(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetMemberResponse
  ): zio.aws.macie2.model.GetMemberResponse.ReadOnly = new Wrapper(impl)
}
