package zio.aws.macie2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters._
final case class CreateCustomDataIdentifierRequest(
    clientToken: Option[__string] = None,
    description: Option[__string] = None,
    ignoreWords: Option[Iterable[__string]] = None,
    keywords: Option[Iterable[__string]] = None,
    maximumMatchDistance: Option[__integer] = None,
    name: Option[__string] = None,
    regex: Option[__string] = None,
    severityLevels: Option[Iterable[zio.aws.macie2.model.SeverityLevel]] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierRequest = {
    import CreateCustomDataIdentifierRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        ignoreWords.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ignoreWords)
      .optionallyWith(
        keywords.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.keywords)
      .optionallyWith(
        maximumMatchDistance.map(value => __integer.unwrap(value): Integer)
      )(_.maximumMatchDistance)
      .optionallyWith(
        name.map(value => __string.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        regex.map(value => __string.unwrap(value): java.lang.String)
      )(_.regex)
      .optionallyWith(
        severityLevels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.severityLevels)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.CreateCustomDataIdentifierRequest.ReadOnly =
    zio.aws.macie2.model.CreateCustomDataIdentifierRequest.wrap(buildAwsValue())
}
object CreateCustomDataIdentifierRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CreateCustomDataIdentifierRequest =
      zio.aws.macie2.model.CreateCustomDataIdentifierRequest(
        clientToken.map(value => value),
        description.map(value => value),
        ignoreWords.map(value => value),
        keywords.map(value => value),
        maximumMatchDistance.map(value => value),
        name.map(value => value),
        regex.map(value => value),
        severityLevels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value)
      )
    def clientToken: Option[__string]
    def description: Option[__string]
    def ignoreWords: Option[List[__string]]
    def keywords: Option[List[__string]]
    def maximumMatchDistance: Option[__integer]
    def name: Option[__string]
    def regex: Option[__string]
    def severityLevels
        : Option[List[zio.aws.macie2.model.SeverityLevel.ReadOnly]]
    def tags: Option[Map[__string, __string]]
    def getClientToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getIgnoreWords: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("ignoreWords", ignoreWords)
    def getKeywords: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("keywords", keywords)
    def getMaximumMatchDistance: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maximumMatchDistance", maximumMatchDistance)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getRegex: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("regex", regex)
    def getSeverityLevels: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.SeverityLevel.ReadOnly
    ]] = AwsError.unwrapOptionField("severityLevels", severityLevels)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierRequest
  ) extends zio.aws.macie2.model.CreateCustomDataIdentifierRequest.ReadOnly {
    override val clientToken: Option[__string] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val ignoreWords: Option[List[__string]] = scala
      .Option(impl.ignoreWords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.primitives.__string(item)
        }.toList
      )
    override val keywords: Option[List[__string]] = scala
      .Option(impl.keywords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.primitives.__string(item)
        }.toList
      )
    override val maximumMatchDistance: Option[__integer] = scala
      .Option(impl.maximumMatchDistance())
      .map(value => zio.aws.macie2.model.primitives.__integer(value))
    override val name: Option[__string] = scala
      .Option(impl.name())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val regex: Option[__string] = scala
      .Option(impl.regex())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val severityLevels
        : Option[List[zio.aws.macie2.model.SeverityLevel.ReadOnly]] = scala
      .Option(impl.severityLevels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.SeverityLevel.wrap(item)
        }.toList
      )
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.macie2.model.primitives
              .__string(key) -> zio.aws.macie2.model.primitives.__string(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CreateCustomDataIdentifierRequest
  ): zio.aws.macie2.model.CreateCustomDataIdentifierRequest.ReadOnly =
    new Wrapper(impl)
}
