package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.macie2.model.primitives.__string
import scala.jdk.CollectionConverters._
final case class SearchResourcesResponse(
    matchingResources: Option[Iterable[zio.aws.macie2.model.MatchingResource]] =
      None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.SearchResourcesResponse = {
    import SearchResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.SearchResourcesResponse
      .builder()
      .optionallyWith(
        matchingResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.matchingResources)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.SearchResourcesResponse.ReadOnly =
    zio.aws.macie2.model.SearchResourcesResponse.wrap(buildAwsValue())
}
object SearchResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.SearchResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.SearchResourcesResponse =
      zio.aws.macie2.model.SearchResourcesResponse(
        matchingResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def matchingResources
        : Option[List[zio.aws.macie2.model.MatchingResource.ReadOnly]]
    def nextToken: Option[__string]
    def getMatchingResources: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.MatchingResource.ReadOnly
    ]] = AwsError.unwrapOptionField("matchingResources", matchingResources)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.SearchResourcesResponse
  ) extends zio.aws.macie2.model.SearchResourcesResponse.ReadOnly {
    override val matchingResources
        : Option[List[zio.aws.macie2.model.MatchingResource.ReadOnly]] = scala
      .Option(impl.matchingResources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.MatchingResource.wrap(item)
        }.toList
      )
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.SearchResourcesResponse
  ): zio.aws.macie2.model.SearchResourcesResponse.ReadOnly = new Wrapper(impl)
}
