package zio.aws.macie2.model
import java.time.Instant
import zio.aws.macie2.model.primitives.{
  __integer,
  __boolean,
  __timestampIso8601,
  __string
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetCustomDataIdentifierResponse(
    arn: Option[__string] = None,
    createdAt: Option[__timestampIso8601] = None,
    deleted: Option[__boolean] = None,
    description: Option[__string] = None,
    id: Option[__string] = None,
    ignoreWords: Option[Iterable[__string]] = None,
    keywords: Option[Iterable[__string]] = None,
    maximumMatchDistance: Option[__integer] = None,
    name: Option[__string] = None,
    regex: Option[__string] = None,
    severityLevels: Option[Iterable[zio.aws.macie2.model.SeverityLevel]] = None,
    tags: Option[Map[__string, __string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.GetCustomDataIdentifierResponse = {
    import GetCustomDataIdentifierResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.GetCustomDataIdentifierResponse
      .builder()
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        createdAt.map(value => __timestampIso8601.unwrap(value): Instant)
      )(_.createdAt)
      .optionallyWith(
        deleted.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.deleted)
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        id.map(value => __string.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        ignoreWords.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ignoreWords)
      .optionallyWith(
        keywords.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.keywords)
      .optionallyWith(
        maximumMatchDistance.map(value => __integer.unwrap(value): Integer)
      )(_.maximumMatchDistance)
      .optionallyWith(
        name.map(value => __string.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        regex.map(value => __string.unwrap(value): java.lang.String)
      )(_.regex)
      .optionallyWith(
        severityLevels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.severityLevels)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.macie2.model.GetCustomDataIdentifierResponse.ReadOnly =
    zio.aws.macie2.model.GetCustomDataIdentifierResponse.wrap(buildAwsValue())
}
object GetCustomDataIdentifierResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.GetCustomDataIdentifierResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.GetCustomDataIdentifierResponse =
      zio.aws.macie2.model.GetCustomDataIdentifierResponse(
        arn.map(value => value),
        createdAt.map(value => value),
        deleted.map(value => value),
        description.map(value => value),
        id.map(value => value),
        ignoreWords.map(value => value),
        keywords.map(value => value),
        maximumMatchDistance.map(value => value),
        name.map(value => value),
        regex.map(value => value),
        severityLevels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value)
      )
    def arn: Option[__string]
    def createdAt: Option[__timestampIso8601]
    def deleted: Option[__boolean]
    def description: Option[__string]
    def id: Option[__string]
    def ignoreWords: Option[List[__string]]
    def keywords: Option[List[__string]]
    def maximumMatchDistance: Option[__integer]
    def name: Option[__string]
    def regex: Option[__string]
    def severityLevels
        : Option[List[zio.aws.macie2.model.SeverityLevel.ReadOnly]]
    def tags: Option[Map[__string, __string]]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDeleted: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("deleted", deleted)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getIgnoreWords: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("ignoreWords", ignoreWords)
    def getKeywords: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("keywords", keywords)
    def getMaximumMatchDistance: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maximumMatchDistance", maximumMatchDistance)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getRegex: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("regex", regex)
    def getSeverityLevels: ZIO[Any, AwsError, List[
      zio.aws.macie2.model.SeverityLevel.ReadOnly
    ]] = AwsError.unwrapOptionField("severityLevels", severityLevels)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.GetCustomDataIdentifierResponse
  ) extends zio.aws.macie2.model.GetCustomDataIdentifierResponse.ReadOnly {
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val createdAt: Option[__timestampIso8601] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.macie2.model.primitives.__timestampIso8601(value))
    override val deleted: Option[__boolean] = scala
      .Option(impl.deleted())
      .map(value => zio.aws.macie2.model.primitives.__boolean(value))
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val id: Option[__string] = scala
      .Option(impl.id())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val ignoreWords: Option[List[__string]] = scala
      .Option(impl.ignoreWords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.primitives.__string(item)
        }.toList
      )
    override val keywords: Option[List[__string]] = scala
      .Option(impl.keywords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.primitives.__string(item)
        }.toList
      )
    override val maximumMatchDistance: Option[__integer] = scala
      .Option(impl.maximumMatchDistance())
      .map(value => zio.aws.macie2.model.primitives.__integer(value))
    override val name: Option[__string] = scala
      .Option(impl.name())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val regex: Option[__string] = scala
      .Option(impl.regex())
      .map(value => zio.aws.macie2.model.primitives.__string(value))
    override val severityLevels
        : Option[List[zio.aws.macie2.model.SeverityLevel.ReadOnly]] = scala
      .Option(impl.severityLevels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.macie2.model.SeverityLevel.wrap(item)
        }.toList
      )
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.macie2.model.primitives
              .__string(key) -> zio.aws.macie2.model.primitives.__string(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.GetCustomDataIdentifierResponse
  ): zio.aws.macie2.model.GetCustomDataIdentifierResponse.ReadOnly =
    new Wrapper(impl)
}
