package zio.aws.macie2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSampleFindingsRequest(
    findingTypes: Option[Iterable[zio.aws.macie2.model.FindingType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.macie2.model.CreateSampleFindingsRequest = {
    import CreateSampleFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.macie2.model.CreateSampleFindingsRequest
      .builder()
      .optionallyWith(
        findingTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.findingTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.macie2.model.CreateSampleFindingsRequest.ReadOnly =
    zio.aws.macie2.model.CreateSampleFindingsRequest.wrap(buildAwsValue())
}
object CreateSampleFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.macie2.model.CreateSampleFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.macie2.model.CreateSampleFindingsRequest =
      zio.aws.macie2.model
        .CreateSampleFindingsRequest(findingTypes.map(value => value))
    def findingTypes: Option[List[zio.aws.macie2.model.FindingType]]
    def getFindingTypes
        : ZIO[Any, AwsError, List[zio.aws.macie2.model.FindingType]] =
      AwsError.unwrapOptionField("findingTypes", findingTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.macie2.model.CreateSampleFindingsRequest
  ) extends zio.aws.macie2.model.CreateSampleFindingsRequest.ReadOnly {
    override val findingTypes: Option[List[zio.aws.macie2.model.FindingType]] =
      scala
        .Option(impl.findingTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.macie2.model.FindingType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.macie2.model.CreateSampleFindingsRequest
  ): zio.aws.macie2.model.CreateSampleFindingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
