package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.machinelearning.model.primitives.{EntityName, EntityId}
import scala.jdk.CollectionConverters.*
final case class UpdateBatchPredictionRequest(
    batchPredictionId: EntityId,
    batchPredictionName: EntityName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionRequest = {
    import UpdateBatchPredictionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionRequest
      .builder()
      .batchPredictionId(EntityId.unwrap(batchPredictionId): java.lang.String)
      .batchPredictionName(
        EntityName.unwrap(batchPredictionName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.UpdateBatchPredictionRequest.ReadOnly =
    zio.aws.machinelearning.model.UpdateBatchPredictionRequest
      .wrap(buildAwsValue())
}
object UpdateBatchPredictionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.UpdateBatchPredictionRequest =
      zio.aws.machinelearning.model
        .UpdateBatchPredictionRequest(batchPredictionId, batchPredictionName)
    def batchPredictionId: EntityId
    def batchPredictionName: EntityName
    def getBatchPredictionId: ZIO[Any, Nothing, EntityId] =
      ZIO.succeed(batchPredictionId)
    def getBatchPredictionName: ZIO[Any, Nothing, EntityName] =
      ZIO.succeed(batchPredictionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionRequest
  ) extends zio.aws.machinelearning.model.UpdateBatchPredictionRequest.ReadOnly {
    override val batchPredictionId: EntityId =
      zio.aws.machinelearning.model.primitives
        .EntityId(impl.batchPredictionId())
    override val batchPredictionName: EntityName =
      zio.aws.machinelearning.model.primitives
        .EntityName(impl.batchPredictionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.UpdateBatchPredictionRequest
  ): zio.aws.machinelearning.model.UpdateBatchPredictionRequest.ReadOnly =
    new Wrapper(impl)
}
