package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{
  DataSchema,
  DataRearrangement,
  S3Url,
  RedshiftSelectSqlQuery
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RedshiftDataSpec(
    databaseInformation: zio.aws.machinelearning.model.RedshiftDatabase,
    selectSqlQuery: RedshiftSelectSqlQuery,
    databaseCredentials: zio.aws.machinelearning.model.RedshiftDatabaseCredentials,
    s3StagingLocation: S3Url,
    dataRearrangement: Optional[DataRearrangement] = Optional.Absent,
    dataSchema: Optional[DataSchema] = Optional.Absent,
    dataSchemaUri: Optional[S3Url] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.RedshiftDataSpec = {
    import RedshiftDataSpec.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.RedshiftDataSpec
      .builder()
      .databaseInformation(databaseInformation.buildAwsValue())
      .selectSqlQuery(
        RedshiftSelectSqlQuery.unwrap(selectSqlQuery): java.lang.String
      )
      .databaseCredentials(databaseCredentials.buildAwsValue())
      .s3StagingLocation(S3Url.unwrap(s3StagingLocation): java.lang.String)
      .optionallyWith(
        dataRearrangement.map(value =>
          DataRearrangement.unwrap(value): java.lang.String
        )
      )(_.dataRearrangement)
      .optionallyWith(
        dataSchema.map(value => DataSchema.unwrap(value): java.lang.String)
      )(_.dataSchema)
      .optionallyWith(
        dataSchemaUri.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.dataSchemaUri)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.RedshiftDataSpec.ReadOnly =
    zio.aws.machinelearning.model.RedshiftDataSpec.wrap(buildAwsValue())
}
object RedshiftDataSpec {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.RedshiftDataSpec
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.RedshiftDataSpec =
      zio.aws.machinelearning.model.RedshiftDataSpec(
        databaseInformation.asEditable,
        selectSqlQuery,
        databaseCredentials.asEditable,
        s3StagingLocation,
        dataRearrangement.map(value => value),
        dataSchema.map(value => value),
        dataSchemaUri.map(value => value)
      )
    def databaseInformation
        : zio.aws.machinelearning.model.RedshiftDatabase.ReadOnly
    def selectSqlQuery: RedshiftSelectSqlQuery
    def databaseCredentials
        : zio.aws.machinelearning.model.RedshiftDatabaseCredentials.ReadOnly
    def s3StagingLocation: S3Url
    def dataRearrangement: Optional[DataRearrangement]
    def dataSchema: Optional[DataSchema]
    def dataSchemaUri: Optional[S3Url]
    def getDatabaseInformation: ZIO[
      Any,
      Nothing,
      zio.aws.machinelearning.model.RedshiftDatabase.ReadOnly
    ] = ZIO.succeed(databaseInformation)
    def getSelectSqlQuery: ZIO[Any, Nothing, RedshiftSelectSqlQuery] =
      ZIO.succeed(selectSqlQuery)
    def getDatabaseCredentials: ZIO[
      Any,
      Nothing,
      zio.aws.machinelearning.model.RedshiftDatabaseCredentials.ReadOnly
    ] = ZIO.succeed(databaseCredentials)
    def getS3StagingLocation: ZIO[Any, Nothing, S3Url] =
      ZIO.succeed(s3StagingLocation)
    def getDataRearrangement: ZIO[Any, AwsError, DataRearrangement] =
      AwsError.unwrapOptionField("dataRearrangement", dataRearrangement)
    def getDataSchema: ZIO[Any, AwsError, DataSchema] =
      AwsError.unwrapOptionField("dataSchema", dataSchema)
    def getDataSchemaUri: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("dataSchemaUri", dataSchemaUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.RedshiftDataSpec
  ) extends zio.aws.machinelearning.model.RedshiftDataSpec.ReadOnly {
    override val databaseInformation
        : zio.aws.machinelearning.model.RedshiftDatabase.ReadOnly =
      zio.aws.machinelearning.model.RedshiftDatabase
        .wrap(impl.databaseInformation())
    override val selectSqlQuery: RedshiftSelectSqlQuery =
      zio.aws.machinelearning.model.primitives
        .RedshiftSelectSqlQuery(impl.selectSqlQuery())
    override val databaseCredentials
        : zio.aws.machinelearning.model.RedshiftDatabaseCredentials.ReadOnly =
      zio.aws.machinelearning.model.RedshiftDatabaseCredentials
        .wrap(impl.databaseCredentials())
    override val s3StagingLocation: S3Url =
      zio.aws.machinelearning.model.primitives.S3Url(impl.s3StagingLocation())
    override val dataRearrangement: Optional[DataRearrangement] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataRearrangement())
        .map(value =>
          zio.aws.machinelearning.model.primitives.DataRearrangement(value)
        )
    override val dataSchema: Optional[DataSchema] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSchema())
      .map(value => zio.aws.machinelearning.model.primitives.DataSchema(value))
    override val dataSchemaUri: Optional[S3Url] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSchemaUri())
      .map(value => zio.aws.machinelearning.model.primitives.S3Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.RedshiftDataSpec
  ): zio.aws.machinelearning.model.RedshiftDataSpec.ReadOnly = new Wrapper(impl)
}
