package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters.*
final case class GetEvaluationRequest(evaluationId: EntityId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.GetEvaluationRequest = {
    import GetEvaluationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.GetEvaluationRequest
      .builder()
      .evaluationId(EntityId.unwrap(evaluationId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.GetEvaluationRequest.ReadOnly =
    zio.aws.machinelearning.model.GetEvaluationRequest.wrap(buildAwsValue())
}
object GetEvaluationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.GetEvaluationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.GetEvaluationRequest =
      zio.aws.machinelearning.model.GetEvaluationRequest(evaluationId)
    def evaluationId: EntityId
    def getEvaluationId: ZIO[Any, Nothing, EntityId] = ZIO.succeed(evaluationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.GetEvaluationRequest
  ) extends zio.aws.machinelearning.model.GetEvaluationRequest.ReadOnly {
    override val evaluationId: EntityId =
      zio.aws.machinelearning.model.primitives.EntityId(impl.evaluationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.GetEvaluationRequest
  ): zio.aws.machinelearning.model.GetEvaluationRequest.ReadOnly = new Wrapper(
    impl
  )
}
