package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.EntityId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDataSourceFromS3Response(
    dataSourceId: Optional[EntityId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Response = {
    import CreateDataSourceFromS3Response.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Response
      .builder()
      .optionallyWith(
        dataSourceId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.dataSourceId)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.CreateDataSourceFromS3Response.ReadOnly =
    zio.aws.machinelearning.model.CreateDataSourceFromS3Response
      .wrap(buildAwsValue())
}
object CreateDataSourceFromS3Response {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Response
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.machinelearning.model.CreateDataSourceFromS3Response =
      zio.aws.machinelearning.model
        .CreateDataSourceFromS3Response(dataSourceId.map(value => value))
    def dataSourceId: Optional[EntityId]
    def getDataSourceId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("dataSourceId", dataSourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Response
  ) extends zio.aws.machinelearning.model.CreateDataSourceFromS3Response.ReadOnly {
    override val dataSourceId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSourceId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateDataSourceFromS3Response
  ): zio.aws.machinelearning.model.CreateDataSourceFromS3Response.ReadOnly =
    new Wrapper(impl)
}
