package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.machinelearning.model.primitives.{
  RedshiftClusterIdentifier,
  RedshiftDatabaseName
}
import scala.jdk.CollectionConverters.*
final case class RedshiftDatabase(
    databaseName: RedshiftDatabaseName,
    clusterIdentifier: RedshiftClusterIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.RedshiftDatabase = {
    import RedshiftDatabase.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.RedshiftDatabase
      .builder()
      .databaseName(RedshiftDatabaseName.unwrap(databaseName): java.lang.String)
      .clusterIdentifier(
        RedshiftClusterIdentifier.unwrap(clusterIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.RedshiftDatabase.ReadOnly =
    zio.aws.machinelearning.model.RedshiftDatabase.wrap(buildAwsValue())
}
object RedshiftDatabase {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.RedshiftDatabase
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.RedshiftDatabase =
      zio.aws.machinelearning.model
        .RedshiftDatabase(databaseName, clusterIdentifier)
    def databaseName: RedshiftDatabaseName
    def clusterIdentifier: RedshiftClusterIdentifier
    def getDatabaseName: ZIO[Any, Nothing, RedshiftDatabaseName] =
      ZIO.succeed(databaseName)
    def getClusterIdentifier: ZIO[Any, Nothing, RedshiftClusterIdentifier] =
      ZIO.succeed(clusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.RedshiftDatabase
  ) extends zio.aws.machinelearning.model.RedshiftDatabase.ReadOnly {
    override val databaseName: RedshiftDatabaseName =
      zio.aws.machinelearning.model.primitives
        .RedshiftDatabaseName(impl.databaseName())
    override val clusterIdentifier: RedshiftClusterIdentifier =
      zio.aws.machinelearning.model.primitives
        .RedshiftClusterIdentifier(impl.clusterIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.RedshiftDatabase
  ): zio.aws.machinelearning.model.RedshiftDatabase.ReadOnly = new Wrapper(impl)
}
