package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PredictResponse(
    prediction: Optional[zio.aws.machinelearning.model.Prediction] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.PredictResponse = {
    import PredictResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.PredictResponse
      .builder()
      .optionallyWith(prediction.map(value => value.buildAwsValue()))(
        _.prediction
      )
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.PredictResponse.ReadOnly =
    zio.aws.machinelearning.model.PredictResponse.wrap(buildAwsValue())
}
object PredictResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.PredictResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.PredictResponse =
      zio.aws.machinelearning.model
        .PredictResponse(prediction.map(value => value.asEditable))
    def prediction: Optional[zio.aws.machinelearning.model.Prediction.ReadOnly]
    def getPrediction: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.Prediction.ReadOnly
    ] = AwsError.unwrapOptionField("prediction", prediction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.PredictResponse
  ) extends zio.aws.machinelearning.model.PredictResponse.ReadOnly {
    override val prediction
        : Optional[zio.aws.machinelearning.model.Prediction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.prediction())
        .map(value => zio.aws.machinelearning.model.Prediction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.PredictResponse
  ): zio.aws.machinelearning.model.PredictResponse.ReadOnly = new Wrapper(impl)
}
