package zio.aws.machinelearning.model
import scala.jdk.CollectionConverters.*
sealed trait MLModelType {
  def unwrap: software.amazon.awssdk.services.machinelearning.model.MLModelType
}
object MLModelType {
  def wrap(
      value: software.amazon.awssdk.services.machinelearning.model.MLModelType
  ): zio.aws.machinelearning.model.MLModelType = value match {
    case software.amazon.awssdk.services.machinelearning.model.MLModelType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.machinelearning.model.MLModelType.REGRESSION =>
      val r = REGRESSION
      r
    case software.amazon.awssdk.services.machinelearning.model.MLModelType.BINARY =>
      val r = BINARY
      r
    case software.amazon.awssdk.services.machinelearning.model.MLModelType.MULTICLASS =>
      val r = MULTICLASS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.machinelearning.model.MLModelType {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.MLModelType =
      software.amazon.awssdk.services.machinelearning.model.MLModelType.UNKNOWN_TO_SDK_VERSION
  }
  case object REGRESSION extends zio.aws.machinelearning.model.MLModelType {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.MLModelType =
      software.amazon.awssdk.services.machinelearning.model.MLModelType.REGRESSION
  }
  case object BINARY extends zio.aws.machinelearning.model.MLModelType {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.MLModelType =
      software.amazon.awssdk.services.machinelearning.model.MLModelType.BINARY
  }
  case object MULTICLASS extends zio.aws.machinelearning.model.MLModelType {
    override def unwrap
        : software.amazon.awssdk.services.machinelearning.model.MLModelType =
      software.amazon.awssdk.services.machinelearning.model.MLModelType.MULTICLASS
  }
}
