package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.EntityId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDataSourceResponse(
    dataSourceId: Optional[EntityId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceResponse = {
    import UpdateDataSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceResponse
      .builder()
      .optionallyWith(
        dataSourceId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.dataSourceId)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.UpdateDataSourceResponse.ReadOnly =
    zio.aws.machinelearning.model.UpdateDataSourceResponse.wrap(buildAwsValue())
}
object UpdateDataSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.UpdateDataSourceResponse =
      zio.aws.machinelearning.model
        .UpdateDataSourceResponse(dataSourceId.map(value => value))
    def dataSourceId: Optional[EntityId]
    def getDataSourceId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("dataSourceId", dataSourceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceResponse
  ) extends zio.aws.machinelearning.model.UpdateDataSourceResponse.ReadOnly {
    override val dataSourceId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSourceId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.UpdateDataSourceResponse
  ): zio.aws.machinelearning.model.UpdateDataSourceResponse.ReadOnly =
    new Wrapper(impl)
}
