package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.EntityId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeTagsResponse(
    resourceId: Optional[EntityId] = Optional.Absent,
    resourceType: Optional[zio.aws.machinelearning.model.TaggableResourceType] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.machinelearning.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DescribeTagsResponse = {
    import DescribeTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DescribeTagsResponse
      .builder()
      .optionallyWith(
        resourceId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.DescribeTagsResponse.ReadOnly =
    zio.aws.machinelearning.model.DescribeTagsResponse.wrap(buildAwsValue())
}
object DescribeTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DescribeTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.DescribeTagsResponse =
      zio.aws.machinelearning.model.DescribeTagsResponse(
        resourceId.map(value => value),
        resourceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceId: Optional[EntityId]
    def resourceType
        : Optional[zio.aws.machinelearning.model.TaggableResourceType]
    def tags: Optional[List[zio.aws.machinelearning.model.Tag.ReadOnly]]
    def getResourceId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.TaggableResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.machinelearning.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DescribeTagsResponse
  ) extends zio.aws.machinelearning.model.DescribeTagsResponse.ReadOnly {
    override val resourceId: Optional[EntityId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val resourceType
        : Optional[zio.aws.machinelearning.model.TaggableResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.machinelearning.model.TaggableResourceType.wrap(value)
        )
    override val tags
        : Optional[List[zio.aws.machinelearning.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.machinelearning.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DescribeTagsResponse
  ): zio.aws.machinelearning.model.DescribeTagsResponse.ReadOnly = new Wrapper(
    impl
  )
}
