package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{
  Message,
  S3Url,
  EpochTime,
  EntityId,
  LongType,
  PresignedS3Url,
  EntityName,
  AwsUserArn
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetBatchPredictionResponse(
    batchPredictionId: Option[EntityId] = None,
    mlModelId: Option[EntityId] = None,
    batchPredictionDataSourceId: Option[EntityId] = None,
    inputDataLocationS3: Option[S3Url] = None,
    createdByIamUser: Option[AwsUserArn] = None,
    createdAt: Option[EpochTime] = None,
    lastUpdatedAt: Option[EpochTime] = None,
    name: Option[EntityName] = None,
    status: Option[zio.aws.machinelearning.model.EntityStatus] = None,
    outputUri: Option[S3Url] = None,
    logUri: Option[PresignedS3Url] = None,
    message: Option[Message] = None,
    computeTime: Option[LongType] = None,
    finishedAt: Option[EpochTime] = None,
    startedAt: Option[EpochTime] = None,
    totalRecordCount: Option[LongType] = None,
    invalidRecordCount: Option[LongType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionResponse = {
    import GetBatchPredictionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionResponse
      .builder()
      .optionallyWith(
        batchPredictionId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.batchPredictionId)
      .optionallyWith(
        mlModelId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.mlModelId)
      .optionallyWith(
        batchPredictionDataSourceId.map(value =>
          EntityId.unwrap(value): java.lang.String
        )
      )(_.batchPredictionDataSourceId)
      .optionallyWith(
        inputDataLocationS3.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.inputDataLocationS3)
      .optionallyWith(
        createdByIamUser.map(value =>
          AwsUserArn.unwrap(value): java.lang.String
        )
      )(_.createdByIamUser)
      .optionallyWith(createdAt.map(value => EpochTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => EpochTime.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        name.map(value => EntityName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        outputUri.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.outputUri)
      .optionallyWith(
        logUri.map(value => PresignedS3Url.unwrap(value): java.lang.String)
      )(_.logUri)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        computeTime.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.computeTime)
      .optionallyWith(
        finishedAt.map(value => EpochTime.unwrap(value): Instant)
      )(_.finishedAt)
      .optionallyWith(startedAt.map(value => EpochTime.unwrap(value): Instant))(
        _.startedAt
      )
      .optionallyWith(
        totalRecordCount.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.totalRecordCount)
      .optionallyWith(
        invalidRecordCount.map(value => LongType.unwrap(value): java.lang.Long)
      )(_.invalidRecordCount)
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.GetBatchPredictionResponse.ReadOnly =
    zio.aws.machinelearning.model.GetBatchPredictionResponse
      .wrap(buildAwsValue())
}
object GetBatchPredictionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.GetBatchPredictionResponse =
      zio.aws.machinelearning.model.GetBatchPredictionResponse(
        batchPredictionId.map(value => value),
        mlModelId.map(value => value),
        batchPredictionDataSourceId.map(value => value),
        inputDataLocationS3.map(value => value),
        createdByIamUser.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        name.map(value => value),
        status.map(value => value),
        outputUri.map(value => value),
        logUri.map(value => value),
        message.map(value => value),
        computeTime.map(value => value),
        finishedAt.map(value => value),
        startedAt.map(value => value),
        totalRecordCount.map(value => value),
        invalidRecordCount.map(value => value)
      )
    def batchPredictionId: Option[EntityId]
    def mlModelId: Option[EntityId]
    def batchPredictionDataSourceId: Option[EntityId]
    def inputDataLocationS3: Option[S3Url]
    def createdByIamUser: Option[AwsUserArn]
    def createdAt: Option[EpochTime]
    def lastUpdatedAt: Option[EpochTime]
    def name: Option[EntityName]
    def status: Option[zio.aws.machinelearning.model.EntityStatus]
    def outputUri: Option[S3Url]
    def logUri: Option[PresignedS3Url]
    def message: Option[Message]
    def computeTime: Option[LongType]
    def finishedAt: Option[EpochTime]
    def startedAt: Option[EpochTime]
    def totalRecordCount: Option[LongType]
    def invalidRecordCount: Option[LongType]
    def getBatchPredictionId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("batchPredictionId", batchPredictionId)
    def getMlModelId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("mlModelId", mlModelId)
    def getBatchPredictionDataSourceId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField(
        "batchPredictionDataSourceId",
        batchPredictionDataSourceId
      )
    def getInputDataLocationS3: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("inputDataLocationS3", inputDataLocationS3)
    def getCreatedByIamUser: ZIO[Any, AwsError, AwsUserArn] =
      AwsError.unwrapOptionField("createdByIamUser", createdByIamUser)
    def getCreatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getName: ZIO[Any, AwsError, EntityName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.machinelearning.model.EntityStatus] =
      AwsError.unwrapOptionField("status", status)
    def getOutputUri: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("outputUri", outputUri)
    def getLogUri: ZIO[Any, AwsError, PresignedS3Url] =
      AwsError.unwrapOptionField("logUri", logUri)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getComputeTime: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("computeTime", computeTime)
    def getFinishedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("finishedAt", finishedAt)
    def getStartedAt: ZIO[Any, AwsError, EpochTime] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getTotalRecordCount: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("totalRecordCount", totalRecordCount)
    def getInvalidRecordCount: ZIO[Any, AwsError, LongType] =
      AwsError.unwrapOptionField("invalidRecordCount", invalidRecordCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionResponse
  ) extends zio.aws.machinelearning.model.GetBatchPredictionResponse.ReadOnly {
    override val batchPredictionId: Option[EntityId] = scala
      .Option(impl.batchPredictionId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val mlModelId: Option[EntityId] = scala
      .Option(impl.mlModelId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val batchPredictionDataSourceId: Option[EntityId] = scala
      .Option(impl.batchPredictionDataSourceId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
    override val inputDataLocationS3: Option[S3Url] = scala
      .Option(impl.inputDataLocationS3())
      .map(value => zio.aws.machinelearning.model.primitives.S3Url(value))
    override val createdByIamUser: Option[AwsUserArn] = scala
      .Option(impl.createdByIamUser())
      .map(value => zio.aws.machinelearning.model.primitives.AwsUserArn(value))
    override val createdAt: Option[EpochTime] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val lastUpdatedAt: Option[EpochTime] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val name: Option[EntityName] = scala
      .Option(impl.name())
      .map(value => zio.aws.machinelearning.model.primitives.EntityName(value))
    override val status: Option[zio.aws.machinelearning.model.EntityStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.machinelearning.model.EntityStatus.wrap(value))
    override val outputUri: Option[S3Url] = scala
      .Option(impl.outputUri())
      .map(value => zio.aws.machinelearning.model.primitives.S3Url(value))
    override val logUri: Option[PresignedS3Url] = scala
      .Option(impl.logUri())
      .map(value =>
        zio.aws.machinelearning.model.primitives.PresignedS3Url(value)
      )
    override val message: Option[Message] = scala
      .Option(impl.message())
      .map(value => zio.aws.machinelearning.model.primitives.Message(value))
    override val computeTime: Option[LongType] = scala
      .Option(impl.computeTime())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
    override val finishedAt: Option[EpochTime] = scala
      .Option(impl.finishedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val startedAt: Option[EpochTime] = scala
      .Option(impl.startedAt())
      .map(value => zio.aws.machinelearning.model.primitives.EpochTime(value))
    override val totalRecordCount: Option[LongType] = scala
      .Option(impl.totalRecordCount())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
    override val invalidRecordCount: Option[LongType] = scala
      .Option(impl.invalidRecordCount())
      .map(value => zio.aws.machinelearning.model.primitives.LongType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.GetBatchPredictionResponse
  ): zio.aws.machinelearning.model.GetBatchPredictionResponse.ReadOnly =
    new Wrapper(impl)
}
