package zio.aws.machinelearning.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.{
  PageLimit,
  StringType,
  ComparatorValue
}
import scala.jdk.CollectionConverters.*
final case class DescribeDataSourcesRequest(
    filterVariable: Option[
      zio.aws.machinelearning.model.DataSourceFilterVariable
    ] = None,
    eq: Option[ComparatorValue] = None,
    gt: Option[ComparatorValue] = None,
    lt: Option[ComparatorValue] = None,
    ge: Option[ComparatorValue] = None,
    le: Option[ComparatorValue] = None,
    ne: Option[ComparatorValue] = None,
    prefix: Option[ComparatorValue] = None,
    sortOrder: Option[zio.aws.machinelearning.model.SortOrder] = None,
    nextToken: Option[StringType] = None,
    limit: Option[PageLimit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest = {
    import DescribeDataSourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest
      .builder()
      .optionallyWith(filterVariable.map(value => value.unwrap))(
        _.filterVariable
      )
      .optionallyWith(
        eq.map(value => ComparatorValue.unwrap(value): java.lang.String)
      )(_.eq)
      .optionallyWith(
        gt.map(value => ComparatorValue.unwrap(value): java.lang.String)
      )(_.gt)
      .optionallyWith(
        lt.map(value => ComparatorValue.unwrap(value): java.lang.String)
      )(_.lt)
      .optionallyWith(
        ge.map(value => ComparatorValue.unwrap(value): java.lang.String)
      )(_.ge)
      .optionallyWith(
        le.map(value => ComparatorValue.unwrap(value): java.lang.String)
      )(_.le)
      .optionallyWith(
        ne.map(value => ComparatorValue.unwrap(value): java.lang.String)
      )(_.ne)
      .optionallyWith(
        prefix.map(value => ComparatorValue.unwrap(value): java.lang.String)
      )(_.prefix)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(limit.map(value => PageLimit.unwrap(value): Integer))(
        _.limit
      )
      .build()
  }
  def asReadOnly
      : zio.aws.machinelearning.model.DescribeDataSourcesRequest.ReadOnly =
    zio.aws.machinelearning.model.DescribeDataSourcesRequest
      .wrap(buildAwsValue())
}
object DescribeDataSourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.DescribeDataSourcesRequest =
      zio.aws.machinelearning.model.DescribeDataSourcesRequest(
        filterVariable.map(value => value),
        eq.map(value => value),
        gt.map(value => value),
        lt.map(value => value),
        ge.map(value => value),
        le.map(value => value),
        ne.map(value => value),
        prefix.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        limit.map(value => value)
      )
    def filterVariable
        : Option[zio.aws.machinelearning.model.DataSourceFilterVariable]
    def eq: Option[ComparatorValue]
    def gt: Option[ComparatorValue]
    def lt: Option[ComparatorValue]
    def ge: Option[ComparatorValue]
    def le: Option[ComparatorValue]
    def ne: Option[ComparatorValue]
    def prefix: Option[ComparatorValue]
    def sortOrder: Option[zio.aws.machinelearning.model.SortOrder]
    def nextToken: Option[StringType]
    def limit: Option[PageLimit]
    def getFilterVariable: ZIO[
      Any,
      AwsError,
      zio.aws.machinelearning.model.DataSourceFilterVariable
    ] = AwsError.unwrapOptionField("filterVariable", filterVariable)
    def getEq: ZIO[Any, AwsError, ComparatorValue] =
      AwsError.unwrapOptionField("eq", eq)
    def getGt: ZIO[Any, AwsError, ComparatorValue] =
      AwsError.unwrapOptionField("gt", gt)
    def getLt: ZIO[Any, AwsError, ComparatorValue] =
      AwsError.unwrapOptionField("lt", lt)
    def getGe: ZIO[Any, AwsError, ComparatorValue] =
      AwsError.unwrapOptionField("ge", ge)
    def getLe: ZIO[Any, AwsError, ComparatorValue] =
      AwsError.unwrapOptionField("le", le)
    def getNe: ZIO[Any, AwsError, ComparatorValue] =
      AwsError.unwrapOptionField("ne", ne)
    def getPrefix: ZIO[Any, AwsError, ComparatorValue] =
      AwsError.unwrapOptionField("prefix", prefix)
    def getSortOrder
        : ZIO[Any, AwsError, zio.aws.machinelearning.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, StringType] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLimit: ZIO[Any, AwsError, PageLimit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest
  ) extends zio.aws.machinelearning.model.DescribeDataSourcesRequest.ReadOnly {
    override val filterVariable
        : Option[zio.aws.machinelearning.model.DataSourceFilterVariable] = scala
      .Option(impl.filterVariable())
      .map(value =>
        zio.aws.machinelearning.model.DataSourceFilterVariable.wrap(value)
      )
    override val eq: Option[ComparatorValue] = scala
      .Option(impl.eq())
      .map(value =>
        zio.aws.machinelearning.model.primitives.ComparatorValue(value)
      )
    override val gt: Option[ComparatorValue] = scala
      .Option(impl.gt())
      .map(value =>
        zio.aws.machinelearning.model.primitives.ComparatorValue(value)
      )
    override val lt: Option[ComparatorValue] = scala
      .Option(impl.lt())
      .map(value =>
        zio.aws.machinelearning.model.primitives.ComparatorValue(value)
      )
    override val ge: Option[ComparatorValue] = scala
      .Option(impl.ge())
      .map(value =>
        zio.aws.machinelearning.model.primitives.ComparatorValue(value)
      )
    override val le: Option[ComparatorValue] = scala
      .Option(impl.le())
      .map(value =>
        zio.aws.machinelearning.model.primitives.ComparatorValue(value)
      )
    override val ne: Option[ComparatorValue] = scala
      .Option(impl.ne())
      .map(value =>
        zio.aws.machinelearning.model.primitives.ComparatorValue(value)
      )
    override val prefix: Option[ComparatorValue] = scala
      .Option(impl.prefix())
      .map(value =>
        zio.aws.machinelearning.model.primitives.ComparatorValue(value)
      )
    override val sortOrder: Option[zio.aws.machinelearning.model.SortOrder] =
      scala
        .Option(impl.sortOrder())
        .map(value => zio.aws.machinelearning.model.SortOrder.wrap(value))
    override val nextToken: Option[StringType] =
      scala.Option(impl.nextToken()).map(value => value: StringType)
    override val limit: Option[PageLimit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.machinelearning.model.primitives.PageLimit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest
  ): zio.aws.machinelearning.model.DescribeDataSourcesRequest.ReadOnly =
    new Wrapper(impl)
}
