package zio.aws.machinelearning.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.machinelearning.model.primitives.EntityId
import scala.jdk.CollectionConverters.*
final case class CreateMlModelResponse(mlModelId: Option[EntityId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.machinelearning.model.CreateMlModelResponse = {
    import CreateMlModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.machinelearning.model.CreateMlModelResponse
      .builder()
      .optionallyWith(
        mlModelId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.mlModelId)
      .build()
  }
  def asReadOnly: zio.aws.machinelearning.model.CreateMlModelResponse.ReadOnly =
    zio.aws.machinelearning.model.CreateMlModelResponse.wrap(buildAwsValue())
}
object CreateMlModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.machinelearning.model.CreateMlModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.machinelearning.model.CreateMlModelResponse =
      zio.aws.machinelearning.model
        .CreateMlModelResponse(mlModelId.map(value => value))
    def mlModelId: Option[EntityId]
    def getMlModelId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("mlModelId", mlModelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateMlModelResponse
  ) extends zio.aws.machinelearning.model.CreateMlModelResponse.ReadOnly {
    override val mlModelId: Option[EntityId] = scala
      .Option(impl.mlModelId())
      .map(value => zio.aws.machinelearning.model.primitives.EntityId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.machinelearning.model.CreateMlModelResponse
  ): zio.aws.machinelearning.model.CreateMlModelResponse.ReadOnly = new Wrapper(
    impl
  )
}
